/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.networking.obj;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.entity.obj.other.PaddockSignEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import travelers.server.packet.TravelersPacketsHandler;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.util.helper.PlatformHelper;

public final class UpdatePaddockSignPacket
extends TravelersBasePacket<UpdatePaddockSignPacket> {
    public static final TravelersPacketsHandler<UpdatePaddockSignPacket> handler = UpdatePaddockSignPacket.handler();
    private final ResourceLocation registryName;
    private final String animal;
    private final int entityId;
    public static final ResourceLocation ID = JSCommon.createId("paddock_sign");

    public UpdatePaddockSignPacket(ResourceLocation registryName, String animal, int entityId) {
        this.registryName = registryName;
        this.animal = animal;
        this.entityId = entityId;
    }

    public UpdatePaddockSignPacket(FriendlyByteBuf buf) {
        this.registryName = buf.m_130281_();
        this.animal = buf.m_130277_();
        this.entityId = buf.readInt();
    }

    public UpdatePaddockSignPacket() {
        this.registryName = null;
        this.animal = null;
        this.entityId = 0;
    }

    public ResourceLocation registryName() {
        return this.registryName;
    }

    public String animal() {
        return this.animal;
    }

    public int entityId() {
        return this.entityId;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.registryName);
        buf.m_130070_(this.animal);
        buf.writeInt(this.entityId);
    }

    public UpdatePaddockSignPacket decode(FriendlyByteBuf buf) {
        return new UpdatePaddockSignPacket(buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    private static TravelersPacketsHandler<UpdatePaddockSignPacket> handler() {
        return new TravelersPacketsHandler<UpdatePaddockSignPacket>(){

            public void handleClient(UpdatePaddockSignPacket packet) {
            }

            public void handleServer(UpdatePaddockSignPacket packet, ServerPlayer sender) {
                ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)packet.registryName());
                try {
                    Entity entity;
                    ServerLevel level = PlatformHelper.properties.getServer().m_129880_(type);
                    if (level != null && (entity = level.m_6815_(packet.entityId())) instanceof PaddockSignEntity) {
                        PaddockSignEntity e = (PaddockSignEntity)entity;
                        e.setAnimal(packet.animal());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

