/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersItems;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSDefaultEntityData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSPlantData;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.item.obj.egg.FertileEggItem;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.util.JSHelper;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import jp.jurassicsaga.server.v2.item.JSV2Items;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import travelers.TravelersMain;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.util.helper.TravelersRegistry;

public class JSItemGroups {
    public static final TravelersRegistry<CreativeModeTab> TABS = new TravelersRegistry(BuiltInRegistries.f_279662_, "jurassicsaga");
    public static Supplier<CreativeModeTab> ITEMS;
    public static Supplier<CreativeModeTab> BLOCKS;
    public static Supplier<CreativeModeTab> PLANTS;
    public static Supplier<CreativeModeTab> GENETICS;
    public static Supplier<CreativeModeTab> SPAWN_EGGS;

    public static void init() {
        ITEMS = TABS.register("js.items", () -> JSHelper.jsPlatform.registerMenu((Component)Component.m_237115_((String)"itemGroup.jurassicsaga.items"), JSV1Items.PADDOCK_SIGN, (version, output) -> {
            ArrayList<TravelersItemInterface> ITEM_ARRAY = new ArrayList<TravelersItemInterface>();
            ArrayList<TravelersItemInterface> EXTINCT_ITEM_ARRAY = new ArrayList<TravelersItemInterface>();
            for (JSAnimal<?> jSAnimal : JSAnimals.getAnimals()) {
                if (version != Versions.ALL && jSAnimal.getAnimalAttributes().getMiscProperties().getVersion() != version) continue;
                if (jSAnimal.getAnimalAttributes().getMiscProperties().isExtinct()) {
                    EXTINCT_ITEM_ARRAY.add(jSAnimal.getItems());
                }
                ITEM_ARRAY.add(jSAnimal.getItems());
            }
            for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
                if (version != Versions.ALL && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getHatched_egg() == null) continue;
                output.add(((Item)jSTravelersItems.getHatched_egg().get()).m_7968_());
                if (!TravelersMain.isDebugging()) continue;
                EggType eggWithAnimal = jSTravelersItems.getAttributes().getItemProperties().getEggtype();
                FertileEggItem fertileEggItem = (FertileEggItem)((Object)((Object)((Object)JSV1Items.getItemFromEggType(eggWithAnimal).get())));
                JSGeneData genData = jSTravelersItems.getAttributes().getGeneticProperties().getDefaultGenetics();
                ItemStack stack = JSGeneUtil.writeToStack(fertileEggItem.m_7968_(), genData);
                output.add(stack);
            }
            for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
                if (version != Versions.ALL && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getBucket() == null) continue;
                output.add(((Item)jSTravelersItems.getBucket().get()).m_7968_());
            }
            for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
                if (version != Versions.ALL && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getCoin() == null) continue;
                output.add(((Item)jSTravelersItems.getCoin().get()).m_7968_());
            }
            JSGenetics.ENTITY_DEFAULT_GENE_DATA.entrySet().stream().sorted(Comparator.comparing(a -> BuiltInRegistries.f_256780_.m_7981_((Object)((EntityType)a.getKey())).m_135815_())).forEach(entry -> {
                if (version == Versions.ALL) {
                    output.add(((Item)((JSDefaultEntityData)entry.getValue()).coin().get()).m_7968_());
                }
            });
            JSGenetics.PLANT_GENETIC_INFORMATION.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                if (version == Versions.ALL || version == ((JSPlantData)entry.getValue()).version) {
                    output.add(((Item)((JSPlantData)entry.getValue()).coin.get()).m_7968_());
                }
            });
            for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
                if (version != Versions.ALL && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getCookedMeat() == null) continue;
                output.add(((Item)jSTravelersItems.getCookedMeat().get()).m_7968_());
                output.add(((Item)jSTravelersItems.getRawMeat().get()).m_7968_());
            }
            for (JSTravelersItems jSTravelersItems : EXTINCT_ITEM_ARRAY) {
                if (version != Versions.ALL && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version || jSTravelersItems.getFossil_remains() == null) continue;
                output.add(((Item)jSTravelersItems.getFossil_remains().get()).m_7968_());
            }
            for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
                if (version != Versions.ALL && jSTravelersItems.getAttributes().getMiscProperties().getVersion() != version) continue;
                jSTravelersItems.getCustom_items().forEach((droppableItem, itemDeferredItem) -> output.add(((Item)itemDeferredItem.get()).m_7968_()));
            }
            if (version == Versions.ALL) {
                for (Iterator<JSAnimal<Object>> iterator : Era.values()) {
                    ((Era)((Object)((Object)((Object)iterator)))).getRegistryMap().forEach((result, itemDeferredItem) -> output.add(((Item)itemDeferredItem.get()).m_7968_()));
                }
                output.add(((Item)JSItems.GUIDEBOOK.get()).m_7968_());
                output.add(((Item)JSItems.JEEP_WRANGLER.get()).m_7968_());
                output.add(((Item)JSItems.JEEP_WRANGLER_COVER.get()).m_7968_());
                output.add(((Item)JSItems.FORD_EXPLORER.get()).m_7968_());
                output.add(((Item)JSV2Items.WRENCH.get()).m_7968_());
                output.add(((Item)JSV1Items.CLICKER.get()).m_7968_());
                output.add(((Item)JSV1Items.KEYCARD.get()).m_7968_());
                output.add(((Item)JSV1Items.EMPTY_TEST_TUBE.get()).m_7968_());
                output.add(((Item)JSV1Items.SYRINGE.get()).m_7968_());
                output.add(((Item)JSV1Items.RED_EYED_TREE_FROG.get()).m_7968_());
                output.add(((Item)JSV1Items.REED_FROG.get()).m_7968_());
                output.add(((Item)JSV1Items.MOSQUITO.get()).m_7968_());
                output.add(((Item)JSV1Items.SQUID.get()).m_7968_());
                output.add(((Item)JSV1Items.SQUID_COOKED.get()).m_7968_());
                output.add(((Item)JSV1Items.PADDOCK_SIGN.get()).m_7968_());
            }
            if (version == Versions.ALL || version == Versions.VERSION_1) {
                output.add(((Item)JSV1Items.ALLIGATOR_EGG.get()).m_7968_());
                output.add(((Item)JSV1Items.FISH_EGG.get()).m_7968_());
                output.add(((Item)JSV1Items.OSTRICH_EGG.get()).m_7968_());
                output.add(((Item)JSV1Items.FROG_EGG.get()).m_7968_());
                output.add(((Item)JSV1Items.BASILISK_EGG.get()).m_7968_());
                output.add(((Item)JSV1Items.SPIDER_EGG.get()).m_7968_());
            }
            return output;
        }));
        BLOCKS = TABS.register("js.blocks", () -> JSHelper.jsPlatform.registerMenu((Component)Component.m_237115_((String)"itemGroup.jurassicsaga.blocks"), (Supplier<Item>)((Supplier)() -> ((Block)JSV1Blocks.BIG_TILE.get()).m_5456_()), (version, output) -> {
            HashSet added = new HashSet();
            Consumer<ItemLike> safeOutput = item -> {
                if (added.add(item)) {
                    output.add(item.m_5456_().m_7968_());
                }
            };
            if (version == Versions.ALL || version == Versions.VERSION_1) {
                JSV1Blocks.addBlocks(safeOutput).run();
            }
            if (version == Versions.ALL || version == Versions.VERSION_2) {
                JSV2Blocks.addBlocks(safeOutput).run();
            }
            return output;
        }));
        PLANTS = TABS.register("js.plants", () -> JSHelper.jsPlatform.registerMenu((Component)Component.m_237115_((String)"itemGroup.jurassicsaga.plants"), (Supplier<Item>)((Supplier)() -> ((Block)JSV1Blocks.SWISS_CHEESE_PLANT.get()).m_5456_()), (version, output) -> {
            HashSet added = new HashSet();
            Consumer<ItemLike> safeOutput = item -> {
                if (added.add(item)) {
                    output.add(item.m_5456_().m_7968_());
                }
            };
            if (version == Versions.ALL || version == Versions.VERSION_1) {
                JSV1Blocks.addPlants(safeOutput).run();
            }
            if (version == Versions.ALL || version == Versions.VERSION_2) {
                JSV2Blocks.addPlants(safeOutput).run();
            }
            return output;
        }));
        GENETICS = TABS.register("js.genetics", () -> JSHelper.jsPlatform.registerMenu((Component)Component.m_237115_((String)"itemGroup.jurassicsaga.genetics"), (Supplier<Item>)((Supplier)() -> (Item)JSGenetics.GENE_ITEMS.get(JSGenetics.LUX).get()), (version, output) -> {
            JSGenetics.GENE_ITEMS.values().stream().map(Supplier::get).sorted(Comparator.comparing(a -> BuiltInRegistries.f_257033_.m_7981_(a).m_135815_())).forEach(o -> {
                if (o instanceof GeneItem) {
                    GeneItem geneItem = (GeneItem)((Object)((Object)((Object)o)));
                    if (version == Versions.ALL || geneItem.getGene().getVersionAdded() == version) {
                        output.add(o.m_7968_());
                    }
                }
            });
            return output;
        }));
        SPAWN_EGGS = TABS.register("js.spawn_eggs", () -> JSHelper.jsPlatform.registerMenu((Component)Component.m_237115_((String)"itemGroup.jurassicsaga.spawn_eggs"), (Supplier<Item>)((Supplier)() -> (Item)JSV1Animals.VELOCIRAPTOR.getItems().getSpawnEgg().get()), (version, output) -> {
            JSAnimals.getAnimals().stream().sorted(Comparator.comparingDouble(a -> a.getAnimalAttributes().getMiscProperties().getVersion().versionId())).filter(a -> version == Versions.ALL || a.getAnimalAttributes().getMiscProperties().getVersion() == version).map(a -> ((Item)a.getItems().getSpawnEgg().get()).m_7968_()).forEach(output::add);
            return output;
        }));
    }
}

