/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item;

import com.google.common.base.Supplier;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.base.item.obj.DebugStickItem;
import jp.jurassicsaga.server.base.item.obj.FossilItem;
import jp.jurassicsaga.server.base.item.obj.GuidebookItem;
import jp.jurassicsaga.server.base.item.obj.VehicleItem;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v2.item.JSV2Items;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import travelers.util.helper.TravelersRegistry;

public class JSItems {
    public static final TravelersRegistry<Item> ITEMS = new TravelersRegistry((Registry)BuiltInRegistries.f_257033_, "jurassicsaga");
    public static Supplier<Item> GUIDEBOOK;
    public static Supplier<Item> JEEP_WRANGLER;
    public static Supplier<Item> JEEP_WRANGLER_COVER;
    public static Supplier<Item> FORD_EXPLORER;
    public static Supplier<Item> BALLOON_TOUR;
    public static Supplier<Item> DEBUG_STICK;

    public static Supplier<Item> registerItem(String name, Supplier<Item> item) {
        return ITEMS.register(name, item);
    }

    public static void init() {
        GUIDEBOOK = JSItems.registerItem("guidebook", (Supplier<Item>)((Supplier)() -> new GuidebookItem(new Item.Properties())));
        JEEP_WRANGLER = JSItems.registerItem("jeep_wrangler", (Supplier<Item>)((Supplier)() -> new VehicleItem(JSEntities.JEEP_WRANGLER)));
        JEEP_WRANGLER_COVER = JSItems.registerItem("jeep_wrangler_cover", (Supplier<Item>)((Supplier)() -> new Item(new Item.Properties().m_41487_(1))));
        FORD_EXPLORER = JSItems.registerItem("ford_explorer", (Supplier<Item>)((Supplier)() -> new VehicleItem(JSEntities.FORD_EXPLORER)));
        DEBUG_STICK = JSItems.registerItem("debug_stick", (Supplier<Item>)((Supplier)DebugStickItem::new));
        JSV1Items.init();
        JSV2Items.init();
    }

    static {
        for (Era value : Era.values()) {
            for (PossibleResult result : value.getResults()) {
                value.getRegistryMap().put(result, JSItems.registerItem(value.getEraName() + "_" + result.getResultName(), (Supplier<Item>)((Supplier)() -> new FossilItem(new Item.Properties(), value, result))));
            }
        }
    }
}

