/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;

public class DebugStickItem
extends Item {
    public DebugStickItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        CompoundTag tag = stack.m_41783_();
        int mode = 0;
        if (tag != null) {
            mode = tag.m_128451_("mode");
        }
        String name = DEBUGMODE.fromId(mode).toString().toLowerCase();
        tooltipComponents.add((Component)Component.m_237119_());
        tooltipComponents.add((Component)Component.m_237113_((String)("Mode: " + name)));
        tooltipComponents.add((Component)Component.m_237113_((String)"Making dinosaurs behave since 1993!").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.f_46443_ && player != null) {
            if (!TravelersMain.isDebugging()) {
                DebugStickItem.message(player, (Component)Component.m_237113_((String)"Cant use this item unless you are in debug mode! Bonk!"));
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            EntityHitResult hitResult = this.getEntityHitResult(level, player, 10.0);
            if (hitResult == null) {
                if (player.m_6144_()) {
                    int newMode;
                    CompoundTag tag = stack.m_41783_();
                    int mode = 0;
                    if (tag != null) {
                        mode = tag.m_128451_("mode");
                    }
                    int n = newMode = mode + 1 < DEBUGMODE.values().length ? Mth.m_14045_((int)(mode + 1), (int)0, (int)(DEBUGMODE.values().length - 1)) : 0;
                    if (tag == null) {
                        tag = new CompoundTag();
                    }
                    tag.m_128405_("mode", newMode);
                    stack.m_41751_(tag);
                    DebugStickItem.message(player, (Component)Component.m_237113_((String)("Mode:" + DEBUGMODE.fromId(newMode).name())));
                }
            } else {
                hitResult.m_82443_();
                Entity mode = hitResult.m_82443_();
                if (mode instanceof LivingEntity) {
                    LivingEntity e = (LivingEntity)mode;
                    InteractionResult result = this.m_6880_(stack, player, e, usedHand);
                    if (result == InteractionResult.SUCCESS) {
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!TravelersMain.isDebugging()) {
                DebugStickItem.message(player, (Component)Component.m_237113_((String)"Cant use this item unless you are in debug mode! Bonk!"));
                return InteractionResult.FAIL;
            }
            if (interactionTarget instanceof JSAnimalBase) {
                JSAnimalBase animal = (JSAnimalBase)interactionTarget;
                CompoundTag tag = stack.m_41783_();
                int modeId = 0;
                if (tag != null) {
                    modeId = tag.m_128451_("mode");
                }
                DEBUGMODE mode = DEBUGMODE.fromId(modeId);
                switch (mode) {
                    case DRAIN_HUNGER: {
                        animal.getModules().getMetabolismModule().setHunger(500);
                        System.out.println("set hunger to 500");
                        break;
                    }
                    case DRAIN_THIRST: {
                        animal.getModules().getMetabolismModule().setThirst(500);
                        System.out.println("set thirst to 500");
                        break;
                    }
                    case HALF_HP: {
                        animal.m_21153_(animal.m_21233_() / 2.0f);
                        System.out.println("set hp to half");
                        break;
                    }
                    case FORCE_LOOK_MATE: {
                        System.out.println("forcing this animal to look for a mate");
                        animal.getModules().getMetabolismModule().resetBreedingCooldown();
                        break;
                    }
                    case PRINT: {
                        System.out.println("--- Bonk Report ---");
                        System.out.println("Animal: " + animal.getAnimal().getAnimalAttributes().getAnimalName() + "/" + (animal.getModules().getGeneticModule().isMale() ? "M" : "F"));
                        System.out.println("HP: " + animal.m_21223_() + "/" + animal.m_21233_());
                        System.out.println("Hunger: " + animal.getModules().getMetabolismModule().getHunger());
                        System.out.println("Thirst: " + animal.getModules().getMetabolismModule().getThirst());
                        System.out.println("Gestation: (" + (animal.getModules().getMetabolismModule().isGestating() ? "P" : "") + ") - " + animal.getModules().getMetabolismModule().getGestation());
                        System.out.println("BreedingCD: " + animal.getModules().getMetabolismModule().getBreedingCooldown());
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(stack, player, interactionTarget, usedHand);
    }

    private static void message(Player player, Component messageComponent) {
        ((ServerPlayer)player).m_240418_(messageComponent, true);
    }

    @Nullable
    private EntityHitResult getEntityHitResult(Level level, Player player, double range) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        ItemStack offhand = player.m_21206_();
        if (offhand.m_41720_() == Items.f_151059_) {
            range *= 10.0;
        }
        Vec3 end = eyePos.m_82549_(lookVec.m_82490_(range));
        AABB aabb = player.m_20191_().m_82369_(lookVec.m_82490_(range)).m_82400_(1.0);
        return ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)eyePos, (Vec3)end, (AABB)aabb, entity -> !entity.m_5833_() && entity.m_6087_());
    }

    private static enum DEBUGMODE {
        DRAIN_HUNGER(0),
        DRAIN_THIRST(1),
        HALF_HP(2),
        FORCE_LOOK_MATE(3),
        PRINT(4);

        private final int id;

        private DEBUGMODE(int i) {
            this.id = i;
        }

        public static DEBUGMODE fromId(int t) {
            for (DEBUGMODE value : DEBUGMODE.values()) {
                if (value.id != t) continue;
                return value;
            }
            return DRAIN_HUNGER;
        }
    }
}

