/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.egg;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.AnimalAttachment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.client.TravelersClient;

public class GenderSpawnEgg
extends SpawnEggItem
implements AnimalAttachment {
    private static final List<GenderSpawnEgg> MOD_EGGS = new ArrayList<GenderSpawnEgg>();
    private static final DispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction face = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41784_());
        try {
            Entity base = type.m_20615_((Level)source.m_7727_());
            if (base instanceof JSAnimalBase) {
                JSAnimalBase entity = (JSAnimalBase)base;
                Item patt2755$temp = stack.m_41720_();
                if (patt2755$temp instanceof GenderSpawnEgg) {
                    GenderSpawnEgg spawnEgg = (GenderSpawnEgg)patt2755$temp;
                    CompoundTag tag = stack.m_41784_();
                    int integer = SpawnEggMode.BOTH.id;
                    if (tag.m_128441_("spawn_type")) {
                        integer = tag.m_128451_("spawn_type");
                    } else {
                        tag.m_128405_("spawn_type", integer);
                        stack.m_41751_(tag);
                    }
                    SpawnEggMode mode = SpawnEggMode.getMode(integer);
                    if (mode != SpawnEggMode.BOTH) {
                        entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
                    } else {
                        entity.getModules().getGeneticModule().setMale(entity.m_217043_().m_188499_());
                    }
                    entity.getModules().getGrowthStageModule().setMax();
                    entity.getModules().getMetabolismModule().setMax();
                    JSGeneData data = JSGeneUtil.readFromStack(stack);
                    data.setGeneSeed(source.m_7727_().m_213780_().m_188502_());
                    data.setDataOwnerName(spawnEgg.animal.getAnimalAttributes().getModId() + ":" + spawnEgg.animal.getAnimalAttributes().getAnimalName());
                    entity.getModules().getGeneticModule().setGeneData(data);
                    entity.getModules().getGeneticModule().hatch();
                    stack.m_41774_(1);
                    entity.m_146884_(source.m_7961_().m_121945_(face).m_252807_());
                    entity.m_6518_((ServerLevelAccessor)source.m_7727_(), source.m_7727_().m_6436_(source.m_7961_()), MobSpawnType.SPAWN_EGG, null, new CompoundTag());
                    source.m_7727_().m_7967_((Entity)entity);
                    source.m_7727_().m_220407_(GameEvent.f_157810_, source.m_7961_(), GameEvent.Context.m_223722_((BlockState)source.m_6414_()));
                }
            }
        }
        catch (Exception exception) {
            DispenseItemBehavior.f_181892_.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.m_7961_(), (Object)exception);
            return ItemStack.f_41583_;
        }
        return stack;
    };
    private final Supplier<? extends EntityType<? extends JSAnimalBase>> typeSupplier;
    public final int backGroundColorMale;
    public final int highlightColorMale;
    public final int backgroundColorFemale;
    public final int highlightColorFemale;
    private final JSAnimal<?> animal;

    public GenderSpawnEgg(JSAnimal<?> animal, Supplier<? extends EntityType<? extends JSAnimalBase>> type, int backgroundColor, int highlightColor, int backGroundColorMale, int highlightColorMale, Item.Properties props) {
        super(type.get(), backgroundColor, highlightColor, props);
        this.typeSupplier = type;
        this.backgroundColorFemale = backgroundColor;
        this.highlightColorFemale = highlightColor;
        this.backGroundColorMale = backGroundColorMale;
        this.highlightColorMale = highlightColorMale;
        this.animal = animal;
        MOD_EGGS.add(this);
    }

    public static SpawnEggMode getSpawnEggMode(Object id) {
        SpawnEggMode curMode;
        int integer = SpawnEggMode.BOTH.id;
        if (id != null && id instanceof Integer) {
            Integer integer1 = (Integer)id;
            integer = integer1;
        }
        SpawnEggMode mode = curMode = SpawnEggMode.getMode(integer);
        if (curMode == SpawnEggMode.BOTH) {
            mode = TravelersClient.clientTicks % 64 > 32 ? SpawnEggMode.MALE : SpawnEggMode.FEMALE;
        }
        return mode;
    }

    private static void showTitle(ServerPlayer serverPlayer, SpawnEggMode mode) {
        MutableComponent textComponent = Component.m_237115_((String)mode.getTranslationKey()).m_130940_(ChatFormatting.GOLD);
        ClientboundSetActionBarTextPacket actionBarPacket = new ClientboundSetActionBarTextPacket((Component)textComponent);
        serverPlayer.f_8906_.m_9829_((Packet)actionBarPacket);
    }

    public static void registerDispense() {
        for (GenderSpawnEgg modEgg : MOD_EGGS) {
            DispenseItemBehavior dispenseBehavior = modEgg.createDispenseBehavior();
            if (dispenseBehavior == null) continue;
            DispenserBlock.m_52672_((ItemLike)modEgg, (DispenseItemBehavior)dispenseBehavior);
        }
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("spawn_type", SpawnEggMode.BOTH.id);
        JSGeneData genes = this.animal.getAnimalAttributes().getGeneticProperties().getSpawnGenetics();
        genes.setBaseQuality(100);
        return JSGeneUtil.writeToStack(stack, genes);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.version").m_130946_(String.valueOf(this.animal.getAnimalAttributes().getMiscProperties().getVersion().versionId())).m_130940_(ChatFormatting.DARK_GRAY));
        if (stack.m_41619_()) {
            return;
        }
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        if (data.geneDataHolder.getGENE_SET().isEmpty()) {
            return;
        }
        if (!JSCommon.isShiftKeyDown && !isAdvanced.m_7050_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.shift_hint").m_130940_(ChatFormatting.BLUE));
        } else if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Genes:"));
            int geneId = 0;
            for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                tooltipComponents.add((Component)Component.m_237113_((String)(++geneId + ". ")).m_7220_((Component)gene.getTranslatableObject()).m_130940_(gene.getToolTipColour()));
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.m_43722_();
        BlockPos blockpos = pContext.m_8083_();
        Direction direction = pContext.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType entitytype = this.m_43228_(itemstack.m_41784_());
        JSAnimalBase entity = (JSAnimalBase)entitytype.m_20615_(level);
        if (entity != null) {
            CompoundTag tag = itemstack.m_41784_();
            int integer = SpawnEggMode.BOTH.id;
            if (tag.m_128441_("spawn_type")) {
                integer = tag.m_128451_("spawn_type");
            } else {
                tag.m_128405_("spawn_type", integer);
                itemstack.m_41751_(tag);
            }
            SpawnEggMode mode = SpawnEggMode.getMode(integer);
            entity.getModules().getMetabolismModule().setMax();
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.setGeneSeed(level.m_213780_().m_188502_());
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.m_6518_((ServerLevelAccessor)level, level.m_6436_(blockpos), MobSpawnType.SPAWN_EGG, null, new CompoundTag());
            entity.getModules().getGeneticModule().hatch();
            if (mode != SpawnEggMode.BOTH) {
                entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
            } else {
                entity.getModules().getGeneticModule().setMale(entity.m_217043_().m_188499_());
            }
            if (player.m_6144_()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.m_146884_(blockpos1.m_252807_());
            level.m_7967_((Entity)entity);
            itemstack.m_41774_(1);
            level.m_142346_((Entity)pContext.m_43723_(), GameEvent.f_157810_, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockHitResult blockhitresult = GenderSpawnEgg.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (pPlayer.m_6144_() && blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            if (!pLevel.m_5776_()) {
                CompoundTag tag = itemstack.m_41784_();
                int integer = SpawnEggMode.BOTH.id;
                if (tag.m_128441_("spawn_type")) {
                    integer = tag.m_128451_("spawn_type");
                } else {
                    tag.m_128405_("spawn_type", integer);
                    itemstack.m_41751_(tag);
                }
                SpawnEggMode mode = SpawnEggMode.getMode(integer);
                tag.m_128405_("spawn_type", SpawnEggMode.nextMode((SpawnEggMode)mode).id);
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    GenderSpawnEgg.showTitle(serverPlayer, SpawnEggMode.nextMode(mode));
                }
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        if (!(pLevel.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (pLevel.m_7966_(pPlayer, blockpos) && pPlayer.m_36204_(blockpos, blockhitresult.m_82434_(), itemstack)) {
            EntityType entitytype = this.m_43228_(itemstack.m_41784_());
            JSAnimalBase entity = (JSAnimalBase)entitytype.m_20615_(pLevel);
            if (entity == null) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            CompoundTag tag = itemstack.m_41784_();
            int integer = SpawnEggMode.BOTH.id;
            if (tag.m_128441_("spawn_type")) {
                integer = tag.m_128451_("spawn_type");
            } else {
                tag.m_128405_("spawn_type", integer);
                itemstack.m_41751_(tag);
            }
            SpawnEggMode mode = SpawnEggMode.getMode(integer);
            if (mode != SpawnEggMode.BOTH) {
                entity.getModules().getGeneticModule().setMale(mode == SpawnEggMode.MALE);
            } else {
                entity.getModules().getGeneticModule().setMale(entity.m_217043_().m_188499_());
            }
            if (pPlayer.m_6144_()) {
                entity.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
                entity.getModules().getGrowthStageModule().setGrowthProgress(0);
            } else {
                entity.getModules().getGrowthStageModule().setMax();
            }
            entity.getModules().getMetabolismModule().setMax();
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.setGeneSeed(pLevel.m_213780_().m_188502_());
            data.setDataOwnerName(this.animal.getAnimalAttributes().getModId() + ":" + this.animal.getAnimalAttributes().getAnimalName());
            entity.getModules().getGeneticModule().setGeneData(data);
            entity.getModules().getGeneticModule().hatch();
            entity.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(blockpos), MobSpawnType.SPAWN_EGG, null, new CompoundTag());
            itemstack.m_41774_(1);
            entity.m_146884_(blockpos.m_252807_());
            pLevel.m_7967_((Entity)entity);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            pLevel.m_220400_((Entity)pPlayer, GameEvent.f_157810_, entity.m_20182_());
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Override
    public JSAnimal<?> getAnimal() {
        return this.animal;
    }

    public static List<GenderSpawnEgg> getMOD_EGGS() {
        return MOD_EGGS;
    }

    public static enum SpawnEggMode {
        BOTH(0, "tooltip.jurassicsaga.genderspawnegg.both"),
        MALE(1, "tooltip.jurassicsaga.genderspawnegg.male"),
        FEMALE(2, "tooltip.jurassicsaga.genderspawnegg.female");

        private static final Random random;
        private final int id;
        private final String translationKey;

        private SpawnEggMode(int id, String translationKey) {
            this.id = id;
            this.translationKey = translationKey;
        }

        public static SpawnEggMode nextMode(SpawnEggMode currentMode) {
            switch (currentMode) {
                case MALE: {
                    return FEMALE;
                }
                case BOTH: {
                    return MALE;
                }
            }
            return BOTH;
        }

        public static SpawnEggMode getMode(int mode) {
            for (SpawnEggMode value : SpawnEggMode.values()) {
                if (value.id != mode) continue;
                return value;
            }
            return BOTH;
        }

        public int getId() {
            return this.id;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        static {
            random = new Random();
        }
    }
}

