/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.egg;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.egg.EggEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HatchedEgg
extends SpawnEggItem {
    private static final List<HatchedEgg> MOD_EGGS = new ArrayList<HatchedEgg>();
    private final Supplier<? extends EntityType<? extends EggEntity>> typeSupplier;
    private final JSGeneData data;
    private final Random rng = new Random();

    public HatchedEgg(JSGeneData data) {
        super((EntityType)JSEntities.EGG.get(), 0xFFFFFF, 0xFFFFFF, new Item.Properties());
        this.typeSupplier = () -> (EntityType)JSEntities.EGG.get();
        this.data = data;
        MOD_EGGS.add(this);
    }

    public ItemStack m_7968_() {
        ItemStack defaultStack = super.m_7968_();
        return JSGeneUtil.writeToStack(defaultStack, this.data);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.m_43722_();
        BlockPos blockpos = pContext.m_8083_();
        Direction direction = pContext.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType<? extends EggEntity> entitytype = this.typeSupplier.get();
        EggEntity mob = new EggEntity(entitytype, level);
        mob.m_6027_(blockpos1.m_252807_().f_82479_ + (double)(this.rng.nextFloat() / 2.0f), blockpos1.m_123342_(), blockpos1.m_252807_().f_82481_ + (double)(this.rng.nextFloat() / 2.0f));
        JSGeneData data = JSGeneUtil.readFromStack(itemstack);
        data = this.data.copy().combine(data);
        mob.setData(data);
        itemstack.m_41774_(1);
        level.m_142346_((Entity)pContext.m_43723_(), GameEvent.f_157810_, blockpos);
        level.m_7967_((Entity)mob);
        mob.m_6210_();
        return InteractionResult.CONSUME;
    }

    @NotNull
    public Optional<Mob> m_43215_(@NotNull Player pPlayer, @NotNull Mob pMob, @NotNull EntityType<? extends Mob> pEntityType, @NotNull ServerLevel pServerLevel, @NotNull Vec3 pPos, @NotNull ItemStack pStack) {
        if (!this.m_43230_(pStack.m_41784_(), pEntityType)) {
            return Optional.empty();
        }
        EntityType<? extends EggEntity> entitytype = this.typeSupplier.get();
        EggEntity mob = new EggEntity(entitytype, (Level)pServerLevel);
        mob.m_7678_(pPos.m_7096_(), pPos.m_7098_(), pPos.m_7094_(), 0.0f, 0.0f);
        JSGeneData data = JSGeneUtil.readFromStack(pStack);
        data.combine(this.data);
        mob.setData(data);
        pStack.m_41774_(1);
        return Optional.of(mob);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockHitResult blockhitresult = HatchedEgg.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        if (!(pLevel.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (pLevel.m_7966_(pPlayer, blockpos) && pPlayer.m_36204_(blockpos, blockhitresult.m_82434_(), itemstack)) {
            EntityType<? extends EggEntity> entitytype = this.typeSupplier.get();
            EggEntity mob = new EggEntity(entitytype, pLevel);
            mob.m_6027_(blockpos.m_252807_().f_82479_ + (double)(this.rng.nextFloat() / 2.0f), blockpos.m_123342_(), blockpos.m_252807_().f_82481_ + (double)(this.rng.nextFloat() / 2.0f));
            JSGeneData data = JSGeneUtil.readFromStack(itemstack);
            data.combine(this.data);
            mob.setData(data);
            itemstack.m_41774_(1);
            pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157810_, blockpos);
            pLevel.m_7967_((Entity)mob);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
        if (stack.m_41619_()) {
            return;
        }
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        CompoundTag tag = stack.m_41784_();
        if (!JSUtils.onShiftTooltip(tooltipFlag, tooltipComponents)) {
            if (data.getBaseQuality() > 0) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.species").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("entity." + data.getDataOwnerName().replace(':', '.'))).m_130940_(ChatFormatting.YELLOW)));
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.dna_quality").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(data.getBaseQuality() + "%")).m_130940_(data.getBaseQuality() < 90 ? (data.getBaseQuality() < 50 ? (data.getBaseQuality() < 25 ? ChatFormatting.RED : ChatFormatting.YELLOW) : ChatFormatting.GOLD) : ChatFormatting.GREEN)));
            }
            if (data.hasDonor()) {
                tooltipComponents.add((Component)Component.m_237119_());
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.donor_info"));
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.species").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("entity." + data.getDonorName().replace(":", "."))).m_130940_(ChatFormatting.YELLOW)));
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.dna_quality").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(data.getDonorQuality() + "%")).m_130940_(data.getDonorQuality() < 90 ? (data.getDonorQuality() < 50 ? (data.getDonorQuality() < 25 ? ChatFormatting.RED : ChatFormatting.YELLOW) : ChatFormatting.GOLD) : ChatFormatting.GREEN)));
            }
            if (data.getTotalCompletion() == 100) {
                if (tag.m_128441_("gene_extractor_tries") && !data.geneDataHolder.getGENE_SET().isEmpty()) {
                    tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.jurassicsaga.extractions_remaining", (Object[])new Object[]{tag.m_128451_("gene_extractor_tries")}).m_130940_(ChatFormatting.GRAY));
                }
                if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
                    tooltipComponents.add((Component)Component.m_237119_());
                    tooltipComponents.add((Component)Component.m_237113_((String)"Genes:"));
                    int i = 0;
                    for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                        tooltipComponents.add((Component)Component.m_237113_((String)(++i + ". ")).m_7220_((Component)gene.getTranslatableObject()).m_130940_(gene.getToolTipColour()));
                    }
                }
            }
        }
    }
}

