/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.genetics;

import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.OtherDnaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneticsItem
extends Item {
    public GeneticsItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return super.m_142422_(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        CompoundTag tag = stack.m_41783_();
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        if (data.hasData()) {
            if (JSCommon.isShiftKeyDown) {
                if (data.getTotalCompletion() > 0) {
                    if (data.getGeneType() == GeneType.CREATURE) {
                        location = ResourceLocation.m_135822_((String)data.getDataOwnerName(), (char)':');
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.species").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("entity." + location.m_135827_() + "." + location.m_135815_())).m_130940_(ChatFormatting.YELLOW)));
                    } else if (data.getGeneType() == GeneType.PLANT) {
                        location = ResourceLocation.m_135822_((String)data.getDataOwnerName(), (char)':');
                        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.plant").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("block." + location.m_135827_() + "." + location.m_135815_())).m_130940_(ChatFormatting.YELLOW)));
                    }
                    int quality = data.getBaseQuality();
                    ChatFormatting color = JSUtils.getQualityColor(quality);
                    tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.dna_quality").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(quality + "%")).m_130940_(color)));
                }
                if (data.hasDonor()) {
                    ResourceLocation location = ResourceLocation.m_135822_((String)data.getDonorName(), (char)':');
                    tooltipComponents.add((Component)Component.m_237119_());
                    tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.donor_info"));
                    tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.species").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("entity." + location.m_135827_() + "." + location.m_135815_())).m_130940_(ChatFormatting.YELLOW)));
                    tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.dna_quality").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(data.getDonorQuality() + "%")).m_130940_(data.getDonorQuality() < 90 ? (data.getDonorQuality() < 50 ? (data.getDonorQuality() < 25 ? ChatFormatting.RED : ChatFormatting.YELLOW) : ChatFormatting.GOLD) : ChatFormatting.GREEN)));
                }
                if (data.getTotalCompletion() >= 75) {
                    if (tag != null && tag.m_128441_("gene_extractor_tries") && !data.geneDataHolder.getGENE_SET().isEmpty()) {
                        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.jurassicsaga.extractions_remaining", (Object[])new Object[]{tag.m_128451_("gene_extractor_tries")}).m_130940_(ChatFormatting.GRAY));
                    }
                    if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
                        tooltipComponents.add((Component)Component.m_237119_());
                        tooltipComponents.add((Component)Component.m_237113_((String)"Genes:"));
                        int i = 0;
                        for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                            tooltipComponents.add((Component)Component.m_237113_((String)(++i + ". ")).m_7220_((Component)gene.getTranslatableObject().m_130940_(gene.getToolTipColour())));
                        }
                    }
                } else if (this instanceof DnaItem || this instanceof OtherDnaItem) {
                    tooltipComponents.add((Component)Component.m_237119_());
                    tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.dna_increase_quality").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                }
            } else {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.shift_hint").m_130940_(ChatFormatting.BLUE));
            }
        }
    }
}

