/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.genetics;

import java.util.List;
import java.util.Locale;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSPlantData;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;
import jp.jurassicsaga.server.base.item.obj.JSItemExtension;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneticsItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyringeItem
extends GeneticsItem
implements JSItemExtension {
    public SyringeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.m_128405_("container_full", 0);
        tag.m_128405_("CustomModelData", SampleColour.EMPTY.model());
        stack.m_41751_(tag);
        return stack;
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        boolean hasNone;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        int containerFull = tag.m_128451_("container_full");
        int customModelData = tag.m_128451_("CustomModelData");
        String entity_name = tag.m_128461_("entity_name");
        boolean empty = containerFull == 0 && customModelData == 0;
        boolean dirty = customModelData == SampleColour.DIRTY.model();
        boolean bl = hasNone = entity_name.equals("none") || entity_name.isEmpty();
        if (dirty) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.syringe_clean_hint").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        } else if (empty || hasNone) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.syringe_use_hint").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.jurassicsaga.syringe_analyze_hint").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    @NotNull
    public String m_5671_(ItemStack stack) {
        boolean hasNone;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        int customModelData = tag.m_128451_("CustomModelData");
        String entity_name = tag.m_128461_("entity_name");
        boolean dirty = customModelData == SampleColour.DIRTY.model();
        boolean bl = hasNone = entity_name.equals("none") || entity_name.isEmpty();
        if (dirty) {
            return "item.jurassicsaga." + String.valueOf((Object)SampleColour.DIRTY) + "_syringe";
        }
        if (hasNone) {
            return "item.jurassicsaga." + String.valueOf((Object)SampleColour.EMPTY) + "_syringe";
        }
        return "item.jurassicsaga." + String.valueOf((Object)SampleColour.RED) + "_syringe";
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        if (!player.m_9236_().f_46443_ && interactionTarget.m_6084_()) {
            JSAnimalBase animal;
            boolean empty;
            ItemStack syringe = new ItemStack((ItemLike)this, 1);
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            int containerFull = tag.m_128451_("container_full");
            int customModelData = tag.m_128451_("CustomModelData");
            boolean bl = empty = containerFull == 0 && customModelData == 0;
            if (!empty) {
                return InteractionResult.FAIL;
            }
            if (interactionTarget instanceof JSAnimalBase && (animal = (JSAnimalBase)interactionTarget).getAnimal().getItems().getCoin() != null) {
                JSGeneData data = animal.getModules().getGeneticModule().getGeneData();
                JSGeneUtil.writeToStack(syringe, data);
                tag.m_128405_("container_full", 1);
                tag.m_128405_("CustomModelData", animal.getAnimal().getAnimalAttributes().getItemProperties().getSampleColour().model());
                tag.m_128359_("entity_name", animal.getAnimal().getAnimalAttributes().getModId() + ":" + animal.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT));
                syringe.m_41751_(tag);
                player.m_150109_().m_36054_(syringe);
                stack.m_41774_(1);
                player.m_150109_().m_6596_();
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
            if (JSGenetics.ENTITY_DEFAULT_GENE_DATA.containsKey(interactionTarget.m_6095_())) {
                JSGeneData data = JSGenetics.ENTITY_DEFAULT_GENE_DATA.get(interactionTarget.m_6095_()).geneData();
                JSGeneUtil.writeToStack(syringe, data);
                tag.m_128405_("container_full", 1);
                tag.m_128405_("CustomModelData", SampleColour.RED.model());
                ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)interactionTarget.m_6095_());
                tag.m_128359_("entity_name", key.m_135827_() + ":" + key.m_135815_());
                syringe.m_41751_(tag);
                player.m_150109_().m_36054_(syringe);
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        ResourceLocation name = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        JSPlantData data = JSGenetics.PLANT_GENETIC_INFORMATION.get(name.m_135815_());
        if (data != null) {
            boolean empty;
            ItemStack syringe = new ItemStack((ItemLike)this, 1);
            CompoundTag tag = context.m_43722_().m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            int containerFull = tag.m_128451_("container_full");
            int customModelData = tag.m_128451_("CustomModelData");
            boolean bl = empty = containerFull == 0 && customModelData == 0;
            if (!empty) {
                return InteractionResult.FAIL;
            }
            tag.m_128405_("container_full", 1);
            tag.m_128405_("CustomModelData", SampleColour.PLANT.model());
            tag.m_128359_("entity_name", name.toString());
            if (context.m_43723_() != null) {
                syringe.m_41751_(tag);
                context.m_43723_().m_150109_().m_36054_(syringe);
                context.m_43722_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!stack.m_41619_()) {
            boolean empty;
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
            }
            int containerFull = tag.m_128451_("container_full");
            int customModelData = tag.m_128451_("CustomModelData");
            boolean bl = empty = containerFull == 0 && customModelData == 0;
            if (empty) {
                return false;
            }
            if (entity.m_20069_()) {
                tag.m_128473_("container_full");
                tag.m_128473_("CustomModelData");
                tag.m_128473_("entity_name");
                tag.m_128473_("dna_quality");
                tag.m_128405_("container_full", 0);
                tag.m_128405_("CustomModelData", SampleColour.EMPTY.model());
                stack.m_41751_(tag);
            }
        }
        return false;
    }
}

