/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.recipe.craftingtable;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.item.obj.egg.SimpleEggItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.base.recipe.JSRecipes;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DefertilizeEggRecipe
extends ShapelessRecipe {
    public DefertilizeEggRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(JSCommon.createId("defertilize_egg_serializer"), group, category, result, ingredients);
    }

    public boolean m_5818_(CraftingContainer input, Level level) {
        StackedContents stackedcontents = new StackedContents();
        int size = 0;
        for (int j = 0; j < input.m_6643_(); ++j) {
            ItemStack itemstack = input.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++size;
            stackedcontents.m_36468_(itemstack, 1);
        }
        if (size != 2) {
            return false;
        }
        if (level.f_46443_) {
            return false;
        }
        boolean hasSyringe = false;
        boolean hasEgg = false;
        for (int i = 0; i < input.m_6643_(); ++i) {
            ItemStack stack = input.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == JSV1Items.SYRINGE.get()) {
                hasSyringe = true;
                continue;
            }
            if (!(item instanceof SimpleEggItem) && !stack.m_204117_(ItemTags.f_279581_) && !stack.m_150930_(Items.f_42521_)) continue;
            hasEgg = true;
        }
        return hasEgg && hasSyringe;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_271738_() {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JSRecipes.DEFERTILIZED_EGG_SERIALIZER.get();
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        ItemStack unfert = null;
        boolean isChicken = false;
        boolean isSeed = false;
        boolean isEmpty = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Item item;
            ItemStack item2 = inv.m_8020_(i);
            if (item2.m_41720_() instanceof SyringeItem && !isEmpty) {
                CompoundTag tag = item2.m_41783_();
                int cmd = 0;
                if (tag != null && tag.m_128425_("CustomModelData", 3)) {
                    cmd = tag.m_128451_("CustomModelData");
                }
                boolean bl = isEmpty = cmd == 0;
            }
            if ((item = item2.m_41720_()) instanceof SimpleEggItem) {
                SimpleEggItem egg = (SimpleEggItem)item;
                unfert = egg.getUnfertileEgg().m_7968_();
                continue;
            }
            if (item2.m_41720_() == Items.f_42521_) {
                isChicken = true;
                continue;
            }
            if (!item2.m_204117_(ItemTags.f_279581_)) continue;
            isSeed = true;
        }
        if (!isEmpty) {
            return ItemStack.f_41583_;
        }
        if (isChicken) {
            return ((Item)JSV1Items.CHICKEN_EGG_UNFERTILIZED.get()).m_7968_();
        }
        if (isSeed) {
            return ((Item)JSV1Items.SEEDS_UNFERTILIZED.get()).m_7968_();
        }
        return unfert != null ? unfert : ItemStack.f_41583_;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!(item.m_41720_() instanceof SyringeItem)) continue;
            ItemStack stack = ((Item)JSV1Items.SYRINGE.get()).m_7968_();
            stack.m_41784_().m_128405_("CustomModelData", 1);
            remaining.set(i, (Object)stack);
        }
        return remaining;
    }

    public static class Serializer
    implements RecipeSerializer<DefertilizeEggRecipe> {
        @NotNull
        public DefertilizeEggRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_216455_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"misc"));
            JsonArray ingredientsArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(ingredientsArray);
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 9");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new DefertilizeEggRecipe(group, category, result, ingredients);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray array) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)array.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @NotNull
        public DefertilizeEggRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            int count = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
            for (int i = 0; i < count; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            return new DefertilizeEggRecipe(group, category, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull DefertilizeEggRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.m_130068_((Enum)recipe.m_245232_());
            NonNullList ingredients = recipe.m_7527_();
            buf.m_130130_(ingredients.size());
            for (Ingredient ingredient : ingredients) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }
    }
}

