/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.recipe.craftingtable;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.item.obj.InfertilePlantItem;
import jp.jurassicsaga.server.base.item.obj.egg.InfertileEggItem;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneticsItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.base.recipe.JSRecipes;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class FertilizedEggRecipe
extends ShapelessRecipe {
    public FertilizedEggRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(JSCommon.createId("fertilized_egg"), group, category, result, ingredients);
    }

    public boolean m_5818_(CraftingContainer input, @NotNull Level level) {
        StackedContents stackedcontents = new StackedContents();
        int size = 0;
        for (int j = 0; j < input.m_6643_(); ++j) {
            ItemStack itemstack = input.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++size;
            stackedcontents.m_36468_(itemstack, 1);
        }
        if (size != 3) {
            return false;
        }
        if (level.f_46443_) {
            return false;
        }
        boolean hasSyringe = false;
        boolean hasEgg = false;
        boolean hasDna = false;
        for (int i = 0; i < input.m_6643_(); ++i) {
            ItemStack stack = input.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item == JSV1Items.SYRINGE.get()) {
                hasSyringe = true;
                continue;
            }
            if (item instanceof InfertileEggItem || item instanceof InfertilePlantItem) {
                hasEgg = true;
                continue;
            }
            if (!(item instanceof GeneticsItem) || !(item instanceof DnaItem) && !(item instanceof PlantDnaItem)) continue;
            hasDna = true;
        }
        return hasSyringe && hasEgg && hasDna;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_271738_() {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JSRecipes.FERTILIZED_EGG_SERIALIZER.get();
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        ItemStack item;
        ItemStack coin = null;
        ItemStack egg = null;
        JSAnimal<?> animal = null;
        ItemStack result = null;
        boolean isEmpty = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Item item2;
            item = inv.m_8020_(i);
            if (item.m_41720_() instanceof SyringeItem && !isEmpty) {
                CompoundTag tag = item.m_41783_();
                int cmd = 0;
                if (tag != null && tag.m_128425_("CustomModelData", 3)) {
                    cmd = tag.m_128451_("CustomModelData");
                }
                boolean bl = isEmpty = cmd == 0;
            }
            if ((item2 = item.m_41720_()) instanceof DnaItem) {
                DnaItem dna = (DnaItem)item2;
                coin = item;
                animal = dna.getAnimal();
                continue;
            }
            item2 = item.m_41720_();
            if (item2 instanceof PlantDnaItem) {
                PlantDnaItem plantDnaItem = (PlantDnaItem)item2;
                coin = item;
                result = ((Block)JSGenetics.PLANT_GENETIC_INFORMATION.get((Object)plantDnaItem.getHolderName()).result.get()).m_5456_().m_7968_();
                continue;
            }
            if (!item.m_204117_(JSItemTags.UNFERTILIZED_EGGS)) continue;
            egg = item;
        }
        if (coin == null || egg == null || !isEmpty) {
            return ItemStack.f_41583_;
        }
        item = egg.m_41720_();
        if (item instanceof InfertileEggItem) {
            InfertileEggItem item3 = (InfertileEggItem)item;
            if (animal == null) {
                return ItemStack.f_41583_;
            }
            if (item3.getEggType() == animal.getAnimalAttributes().getItemProperties().getEggtype()) {
                eggCopy = item3.getFertileVersion().m_7968_();
                genData = JSGeneUtil.readFromStack(coin);
                JSGeneUtil.writeToStack(eggCopy, genData);
                return eggCopy;
            }
        } else if (egg.m_41720_() instanceof InfertilePlantItem) {
            if (result == null) {
                return ItemStack.f_41583_;
            }
            eggCopy = ((Item)JSV1Items.SEEDS_FERTILIZED.get()).m_7968_();
            genData = JSGeneUtil.readFromStack(coin);
            genData.setGeneType(GeneType.PLANT);
            JSGeneUtil.writeToStack(eggCopy, genData);
            return eggCopy;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!(item.m_41720_() instanceof SyringeItem)) continue;
            ItemStack stack = ((Item)JSV1Items.SYRINGE.get()).m_7968_();
            stack.m_41784_().m_128405_("CustomModelData", 1);
            remaining.set(i, (Object)stack);
        }
        return remaining;
    }

    public static class Serializer
    implements RecipeSerializer<FertilizedEggRecipe> {
        @NotNull
        public FertilizedEggRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_216455_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"misc"));
            JsonArray ingredientsArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(ingredientsArray);
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 9");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new FertilizedEggRecipe(group, category, result, ingredients);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray array) {
            NonNullList list = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)array.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        @NotNull
        public FertilizedEggRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            int count = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
            for (int i = 0; i < count; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            return new FertilizedEggRecipe(group, category, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull FertilizedEggRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.m_130068_((Enum)recipe.m_245232_());
            NonNullList ingredients = recipe.m_7527_();
            buf.m_130130_(ingredients.size());
            for (Ingredient ingredient : ingredients) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
        }
    }
}

