/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.sound;

import com.google.common.base.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import jp.jurassicsaga.server.v2.sound.JSV2Sounds;
import jp.jurassicsaga.server.v4.sound.JSV4Sounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import travelers.util.helper.TravelersRegistry;

public class JSSounds {
    public static final TravelersRegistry<SoundEvent> SOUND_EVENTS = new TravelersRegistry(BuiltInRegistries.f_256894_, "jurassicsaga");
    public static Supplier<SoundEvent> HATCH_DOOR;
    public static Supplier<SoundEvent> SMALL_STEP;
    public static Supplier<SoundEvent> MEDIUM_STEP;
    public static Supplier<SoundEvent> BIG_STEP;
    public static Supplier<SoundEvent> GIANT_STEP;
    public static Supplier<SoundEvent> CAR_HONK;
    public static Supplier<SoundEvent> CAR_BONK;
    public static Supplier<SoundEvent> CAR_LOOP;
    public static Supplier<SoundEvent> FENCE_SHOCK;

    public static Supplier<SoundEvent> create(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)JSCommon.createId(name)));
    }

    public static Supplier<SoundEvent> create(String name, int range) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.m_262856_((ResourceLocation)JSCommon.createId(name), (float)range));
    }

    public static void init() {
        HATCH_DOOR = JSSounds.create("hatch_door");
        SMALL_STEP = JSSounds.create("small_step");
        MEDIUM_STEP = JSSounds.create("medium_step");
        BIG_STEP = JSSounds.create("big_step");
        GIANT_STEP = JSSounds.create("giant_step");
        CAR_HONK = JSSounds.create("car_honk");
        CAR_BONK = JSSounds.create("car_bonk");
        CAR_LOOP = JSSounds.create("car_loop");
        FENCE_SHOCK = JSSounds.create("fence_shock");
        JSV1Sounds.init();
        JSV2Sounds.init();
        if (!JSCommon.config.experimentalFeatures) {
            return;
        }
        JSV4Sounds.init();
    }
}

