/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.biome;

import jp.jurassicsaga.JSCommon;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class JSBiome {
    private final String biomeName;
    private final ResourceKey<Biome> biomeKey;
    protected boolean hasRain = true;
    protected float temperature = 0.0f;
    protected float downfall = 0.9f;
    protected int waterColor = 50175;
    protected int waterFogColor = 28046;
    protected Integer grassColor = null;
    protected Integer foliageColor = null;
    protected Holder.Reference<SoundEvent> music = SoundEvents.f_184225_;

    public JSBiome(String biomeName) {
        this.biomeName = biomeName;
        this.biomeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)JSCommon.createId(biomeName));
    }

    protected SurfaceRules.ConditionSource surfaceNoiseAbove(double value) {
        return SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)(value / 8.25), (double)Double.MAX_VALUE);
    }

    public final Biome create(BootstapContext<Biome> ctx) {
        MobSpawnSettings.Builder spawner = new MobSpawnSettings.Builder();
        this.addSpawns(ctx, spawner);
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(ctx.m_255420_(Registries.f_256988_), ctx.m_255420_(Registries.f_257003_));
        this.addSettings(ctx, builder);
        Biome.BiomeBuilder biomeBuilder = this.biome(this.hasRain, this.temperature, this.downfall, this.waterColor, this.waterFogColor, this.grassColor, this.foliageColor, spawner, builder, Musics.m_263184_(this.music));
        this.applyExtraSettings(biomeBuilder);
        return biomeBuilder.m_47592_();
    }

    protected void applyExtraSettings(Biome.BiomeBuilder biomeBuilder) {
    }

    protected void addSettings(BootstapContext<Biome> ctx, BiomeGenerationSettings.Builder builder) {
    }

    protected void addSpawns(BootstapContext<Biome> ctx, MobSpawnSettings.Builder spawner) {
    }

    private Biome.BiomeBuilder biome(boolean pHasPrecipitation, float pTemperature, float pDownfall, int pWaterColor, int pWaterFogColor, Integer pGrassColorOverride, Integer pFoliageColorOverride, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, Music pBackgroundMusic) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().m_48034_(pWaterColor).m_48037_(pWaterFogColor).m_48019_(12638463).m_48040_(this.calculateSkyColor(pTemperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(pBackgroundMusic);
        if (pGrassColorOverride != null) {
            biomespecialeffects$builder.m_48045_(pGrassColorOverride.intValue());
        }
        if (pFoliageColorOverride != null) {
            biomespecialeffects$builder.m_48043_(pFoliageColorOverride.intValue());
        }
        return new Biome.BiomeBuilder().m_264558_(pHasPrecipitation).m_47609_(pTemperature).m_47611_(pDownfall).m_47603_(biomespecialeffects$builder.m_48018_()).m_47605_(pMobSpawnSettings.m_48381_()).m_47601_(pGenerationSettings.m_255380_());
    }

    protected int calculateSkyColor(float pTemperature) {
        float $$1 = pTemperature / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    public final SurfaceRules.RuleSource sequence() {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{this.biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{this.innerSequence()}));
    }

    protected SurfaceRules.RuleSource innerSequence() {
        return SurfaceRules.m_189390_((BlockState)Blocks.f_50069_.m_49966_());
    }

    public String getBiomeName() {
        return this.biomeName;
    }

    public ResourceKey<Biome> getBiomeKey() {
        return this.biomeKey;
    }

    public boolean isHasRain() {
        return this.hasRain;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getDownfall() {
        return this.downfall;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public int getWaterFogColor() {
        return this.waterFogColor;
    }

    public Integer getGrassColor() {
        return this.grassColor;
    }

    public Integer getFoliageColor() {
        return this.foliageColor;
    }

    public Holder.Reference<SoundEvent> getMusic() {
        return this.music;
    }
}

