/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.world.feature.obj;

import com.mojang.serialization.Codec;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SmoothBoulderFeature
extends Feature<NoneFeatureConfiguration> {
    public SmoothBoulderFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        RandomSource random = ctx.m_225041_();
        BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        while (ground.m_123342_() > level.m_141937_() && level.m_46859_((BlockPos)ground)) {
            ground.m_122184_(0, -1, 0);
        }
        if (!level.m_6425_((BlockPos)ground).m_76178_() || !level.m_6425_(ground.m_7494_()).m_76178_()) {
            return false;
        }
        ground.m_122184_(0, -random.m_188503_(2), 0);
        int radius = 3 + random.m_188503_(2);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= (double)((float)radius + random.m_188501_() * 0.2f))) continue;
                    BlockPos target = ground.m_7918_(x, y, z);
                    double fade = Math.max(0.0, 1.0 - (double)(-y) / ((double)radius * 1.5));
                    if (!((double)random.m_188501_() < fade)) continue;
                    if ((double)random.m_188501_() < 0.015 && this.isExposed(level, target)) {
                        level.m_7731_(target, ((Block)JSV2Blocks.FUMAROLE.get()).m_49966_(), 2);
                        continue;
                    }
                    if ((double)random.m_188501_() > 0.2) {
                        level.m_7731_(target, ((Block)JSV2Blocks.VOLCANIC_ROCK.get()).m_49966_(), 2);
                        continue;
                    }
                    level.m_7731_(target, ((Block)JSV2Blocks.RHYOLITE.BLOCK.get()).m_49966_(), 2);
                }
            }
        }
        return true;
    }

    private boolean isExposed(WorldGenLevel level, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!level.m_46859_(pos.m_121945_(dir))) continue;
            return true;
        }
        return false;
    }
}

