/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.BasiliskAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.BasiliskEntity;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class BasiliskAnimal
extends AbstractJSAnimal<BasiliskEntity> {
    public BasiliskAnimal() {
        super("basilisk");
        this.setAnimator(new BasiliskAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<BasiliskEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.55f, 0.4f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<BasiliskEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.INSECTOVORE, Diets.INSECTOVORE);
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<BasiliskEntity> miscProperties) {
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
        miscProperties.setEra(Era.NONE);
        miscProperties.addBiomeTarget("jungle", 64, 4, 6, MobCategory.CREATURE, (TagKey<Biome>)BiomeTags.f_207610_);
        miscProperties.setSpawnPlacementType(SpawnPlacements.Type.ON_GROUND);
        miscProperties.setSpawnHeightMap(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        miscProperties.setSpawnPredicate((SpawnPlacements.SpawnPredicate<BasiliskEntity>)((SpawnPlacements.SpawnPredicate)BasiliskEntity::canSpawn));
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<BasiliskEntity> socialGroupProperties) {
        socialGroupProperties.addHerdTargets(BasiliskEntity.class);
        socialGroupProperties.addScaredOf(Player.class);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<BasiliskEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.BASILISK);
        itemProperties.setSpawnEggColors(8506696, 12576115);
        itemProperties.setSpawnEggColorsMale(4973892, 12576115);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<BasiliskEntity> attributes, EntityBaseProperties<BasiliskEntity> base) {
        base.setAnimalType(AnimalType.BIRD);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale((double)0.2f);
        base.setTurnSmoothRate((double)0.6f);
        base.setSpecialRenderer();
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setEntityFactory(BasiliskEntity::new);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setEyeHeight((double)0.2f);
        attributes.setMaxHealth(18.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions((double)0.55f, (double)0.4f);
        attributes.setMovementSpeed((double)0.16f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setSwimmingSpeedMultiplier((double)1.6f);
        attributes.setWaterEfficiency(1.0);
    }
}

