/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.OstrichAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class OstrichAnimal
extends AbstractJSAnimal<OstrichEntity> {
    public OstrichAnimal() {
        super("ostrich");
        this.setAnimator(new OstrichAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<OstrichEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(4.0f));
        geneticProperties.setDefaultGenes(JSGenetics.SAVANNA_COSMETIC);
        geneticProperties.setSpawnGeneticsDefault();
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<OstrichEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.SEEDS);
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<OstrichEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
        miscProperties.addBiomeTarget("savanna", 12, 2, 4, MobCategory.CREATURE, (TagKey<Biome>)BiomeTags.f_215816_);
        miscProperties.setSpawnPlacementType(SpawnPlacements.Type.ON_GROUND);
        miscProperties.setSpawnHeightMap(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        miscProperties.setSpawnPredicate((SpawnPlacements.SpawnPredicate<OstrichEntity>)((SpawnPlacements.SpawnPredicate)OstrichEntity::canSpawn));
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<OstrichEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(12);
        socialGroupProperties.setMaxDistanceToPackLeader(2000.0f);
        socialGroupProperties.setMinDistanceToPackLeader(64.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<OstrichEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColorsMale(1380103, 15980983);
        itemProperties.setSpawnEggColors(4932666, 15188109);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<OstrichEntity> attributes, EntityBaseProperties<OstrichEntity> base) {
        base.setAnimalType(AnimalType.BIRD);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale((double)0.8f);
        base.setTurnSmoothRate((double)0.55f);
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setEntityFactory(OstrichEntity::new);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(18.0);
        attributes.setAttackDamage(9.5);
        attributes.setAttackSpeed(1.0);
        attributes.setWaterEfficiency(1.0);
        attributes.setSpawnFar();
        attributes.setDimensions((double)0.9f, 2.0);
        attributes.setMovementSpeed((double)0.255f);
        attributes.setRunningSpeedMultiplier(2.0);
    }
}

