/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.aquatic;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.aquatic.TylosaurusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.BonitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.CearadactylusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.BrachiosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.StegosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TriceratopsEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.avian.LudodactylusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CallovosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.EuoplocephalusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class TylosaurusAnimal
extends AbstractJSAnimal<TylosaurusEntity> {
    public TylosaurusAnimal() {
        super("tylosaurus");
        this.setAnimator(new TylosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<TylosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.0f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.RAINFOREST_COSMETIC, JSGenetics.STEPPE_COSMETIC, JSGenetics.TUNDRA_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<TylosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.PISCIVORE, Diets.CARNIVORE);
        metabolismProperties.disableWater();
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(8.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<TylosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setGuidebookScaling(new float[]{1.45f, 0.42f});
        miscProperties.setGuidebookOffset(new Vec2(-0.2f, -0.2f), new Vec2(0.0f, 1.8f));
        miscProperties.setExtinct();
        miscProperties.setMachineScale(0.35f);
        miscProperties.setGuideBookDescription("A large marine reptile from the Late Cretaceous, part of the mosasaur family. It could reach over 14 meters in length and was a top predator in its environment, feeding on fish, other marine reptiles, and even smaller mosasaurs.");
        miscProperties.setGuideBookSource("North America");
        miscProperties.setGuideBookScientificName("Tylosaurus proriger");
        miscProperties.setAdvancementTitle("Devil From The Deep");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<TylosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(Animal.class, Monster.class, AbstractVillager.class, WaterAnimal.class, Player.class, BonitoEntity.class, AlligatorEntity.class, GoatEntity.class, OstrichEntity.class, VelociraptorEntity.class, CearadactylusEntity.class, TriceratopsEntity.class, GallimimusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, TroodonEntity.class, ApatosaurusEntity.class, DilophosaurusEntity.class, DryosaurusEntity.class, StegosaurusEntity.class, TyrannosaurusEntity.class, BrachiosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, EuoplocephalusEntity.class, LudodactylusEntity.class, MaiasauraEntity.class, MetriacanthosaurusEntity.class, ProceratosaurusEntity.class, OthnielaEntity.class, MicroceratusEntity.class, StyracosaurusEntity.class, CoelurusEntity.class, CallovosaurusEntity.class, ProtoceratopsEntity.class);
        socialGroupProperties.addHerdTargets(TylosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(1.8f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<TylosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(8951700, 0x272727);
        itemProperties.setSpawnEggColorsMale(0x4D8488, 1846323);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<TylosaurusEntity> attributes, EntityBaseProperties<TylosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(9.0);
        base.setMaxTurnRate(15.0);
        base.setTurnSmoothRate(0.45);
        base.setRenderScale((double)2.1f);
        base.setLocator(new JSAnimalBaseLocator());
        base.setBabyAnimations();
        base.setAnimalType(AnimalType.AQUATIC_MAMMAL);
        attributes.setPersistent();
        attributes.setEntityFactory(TylosaurusEntity::new);
        attributes.setEyeHeight((double)0.85f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(70.0);
        attributes.setDimensions(3.0, 2.0);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(6.0));
        attributes.setSwimmingSpeedMultiplier(4.25);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(30.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

