/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.TroodonAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.BasiliskEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class TroodonAnimal
extends AbstractJSAnimal<TroodonEntity> {
    public TroodonAnimal() {
        super("troodon");
        this.setAnimator(new TroodonAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<TroodonEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.425f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.OCEAN_COSMETIC, JSGenetics.SAVANNA_COSMETIC, JSGenetics.TUNDRA_COSMETIC);
        geneticProperties.setDefaultGenes(JSGenetics.NOCTURNAL);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<TroodonEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(3.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<TroodonEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setGuidebookScaling(new float[]{1.7f, 2.0f});
        miscProperties.setGuidebookOffset(new Vec2(0.5f, 0.0f), new Vec2(-0.5f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setRequiresGlow();
        miscProperties.setGuideBookDescription("A small theropod from the Late Cretaceous with one of the largest brain-to-body ratios among dinosaurs. It had keen senses, grasping hands, and serrated teeth, suggesting it was an intelligent and adaptable predator or omnivore.");
        miscProperties.setGuideBookSource("North America");
        miscProperties.setGuideBookScientificName("Troodon pectinodon");
        miscProperties.setAdvancementTitle("They're Everywhere!");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<TroodonEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class);
        socialGroupProperties.addHuntTargets(Player.class, Animal.class, Monster.class, GallimimusEntity.class, ParasaurolophusEntity.class, DilophosaurusEntity.class, ProcompsognathusEntity.class, GoatEntity.class, OstrichEntity.class, BasiliskEntity.class, MicroceratusEntity.class, OthnielaEntity.class, StyracosaurusEntity.class, CoelurusEntity.class, ProceratosaurusEntity.class, ProtoceratopsEntity.class);
        socialGroupProperties.addHerdTargets(TroodonEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<TroodonEntity> itemProperties) {
        itemProperties.setEggtype(EggType.CHICKEN);
        itemProperties.setSpawnEggColors(10723979, 3417372);
        itemProperties.setSpawnEggColorsMale(8093033, 3417372);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<TroodonEntity> attributes, EntityBaseProperties<TroodonEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(30.0);
        base.setSizeDimorphism(11.0);
        base.setSpecialRenderer();
        base.setRenderScale((double)0.35f);
        base.setLocator(new JSAnimalBaseLocator());
        base.setBabyAnimations();
        base.setTurnSmoothRate((double)0.6f);
        attributes.setPersistent();
        attributes.setEntityFactory(TroodonEntity::new);
        attributes.setEyeHeight((double)0.85f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(25.0);
        attributes.setDimensions((double)0.6f, (double)0.8f);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(9.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(3.0);
        attributes.setAttackDamage(2.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

