/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.TyrannosaurusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.AlligatorEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.MosquitoEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.ReedFrogEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.CearadactylusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.avian.MeganeuraEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.StegosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TriceratopsEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.avian.LudodactylusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.EuoplocephalusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProtoceratopsEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalType;

public class TyrannosaurusAnimal
extends AbstractJSAnimal<TyrannosaurusEntity> {
    public TyrannosaurusAnimal() {
        super("tyrannosaurus");
        this.setAnimator(new TyrannosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<TyrannosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(2.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.FOREST_COSMETIC, JSGenetics.RIVER_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<TyrannosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(6.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(3.0f));
        metabolismProperties.setStalkingSpeedMultiplier(0.7f);
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<TyrannosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setGuidebookScaling(new float[]{1.5f, 0.535f});
        miscProperties.setGuidebookOffset(new Vec2(0.7f, 0.0f), new Vec2(-1.0f, 0.0f));
        miscProperties.setExtinct();
        miscProperties.setGuideBookDescription("Tyrannosaurus (meaning \"tyrant lizard\") is an extinct genus of tyrannosaurid theropod dinosaur that lived in North America during the Late Cretaceous period around 73-66 million years ago.");
        miscProperties.setGuideBookSource("Canada, United States");
        miscProperties.setGuideBookScientificName("Tyrannosaurus rex");
        miscProperties.setAdvancementTitle("We Have A T-rex!");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<TyrannosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(Player.class, AbstractVillager.class, Animal.class, Monster.class, GoatEntity.class, DryosaurusEntity.class, OstrichEntity.class, ApatosaurusEntity.class, TriceratopsEntity.class, VelociraptorEntity.class, DilophosaurusEntity.class, DilophosaurusEntity.class, GallimimusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, AlligatorEntity.class, CearadactylusEntity.class, MeganeuraEntity.class, MosquitoEntity.class, ReedFrogEntity.class, StegosaurusEntity.class, TroodonEntity.class, AchillobatorEntity.class, MetriacanthosaurusEntity.class, MicroceratusEntity.class, StyracosaurusEntity.class, EuoplocephalusEntity.class, LudodactylusEntity.class, ProceratosaurusEntity.class, OthnielaEntity.class, MaiasauraEntity.class, CoelurusEntity.class, ProtoceratopsEntity.class);
        socialGroupProperties.addHerdTargets(TyrannosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(0.5f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<TyrannosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(5193267, 10519632);
        itemProperties.setSpawnEggColorsMale(3357982, 11904615);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<TyrannosaurusEntity> attributes, EntityBaseProperties<TyrannosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(25.0);
        base.setSizeDimorphism(7.0);
        base.setRenderScale((double)2.2f);
        base.setLocator((ResourceLocator)new JSAnimalBaseLocator<TyrannosaurusEntity>(){

            @Override
            public ResourceLocation getTextureLocation(TyrannosaurusEntity entity) {
                JSVariants.JSVariant variant;
                Component customName = entity.m_7770_();
                if (customName != null && customName.getString().toLowerCase(Locale.ROOT).contains("cyclops") && entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && (variant = JSVariants.fromLocation((String)entity.m_20088_().m_135370_(JSEntityDataHolder.textureVariant))) == JSVariants.FOREST) {
                    Object key = this.makeCacheKey(entity, "texture_cyclops");
                    if (entity.m_8077_()) {
                        key = (String)key + "|name=" + entity.m_7770_().getString().toLowerCase(Locale.ROOT);
                    }
                    try {
                        return (ResourceLocation)this.cache.get(key, () -> this.buildTextureLocation(entity));
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.getTextureLocation(entity);
            }

            @Override
            protected ResourceLocation buildTextureLocation(TyrannosaurusEntity entity) {
                Component customName = entity.m_7770_();
                if (customName != null && customName.getString().toLowerCase(Locale.ROOT).contains("cyclops")) {
                    JSVariants.JSVariant variant;
                    String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
                    if (entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && (variant = JSVariants.fromLocation((String)entity.m_20088_().m_135370_(JSEntityDataHolder.textureVariant))) == JSVariants.FOREST) {
                        return new ResourceLocation(JSVariants.FOREST.location().m_135827_(), "textures/geo/animal/v1.0/" + entity_name + "/variants/" + entity_name + "_adult_forest_secret.png");
                    }
                }
                return super.buildTextureLocation(entity);
            }
        });
        base.setBabyAnimations();
        base.setTurnSmoothRate(0.25);
        attributes.setPersistent();
        attributes.setEntityFactory(TyrannosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(120.0);
        attributes.setDimensions(3.0, 6.0);
        attributes.setTrackingRange(64.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(23.0));
        attributes.setWaterEfficiency(1.0);
        attributes.setSwimmingSpeedMultiplier((double)1.3f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(30.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

