/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAmphibiousBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class AlligatorEntity
extends JSAmphibiousBase {
    public AlligatorEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 20));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(10, 6));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        this.m_19983_(new ItemStack((ItemLike)JSV1Items.ALLIGATOR_EGG.get(), this.f_19796_.m_188503_(3) + 1));
    }

    public static boolean canSpawn(EntityType<? extends Entity> jsAnimalBaseEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return AlligatorEntity.checkSurfaceWaterAnimalSpawnRules(jsAnimalBaseEntityType, (LevelAccessor)serverLevelAccessor, mobSpawnType, blockPos, randomSource);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null || this.getFleeTarget() != null) {
            return (SoundEvent)JSV1Sounds.ALLIGATOR_THREAT.get();
        }
        return (SoundEvent)JSV1Sounds.ALLIGATOR_LIVING.get();
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV1Sounds.ALLIGATOR_ATTACK.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.ALLIGATOR_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.ALLIGATOR_HURT.get();
    }

    @Override
    protected boolean usesAir() {
        return false;
    }

    @Override
    public boolean shallowSwimming() {
        return true;
    }

    @Override
    protected boolean sinkToBottom() {
        return false;
    }
}

