/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class BasiliskEntity
extends JSAnimalBase {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(BasiliskEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int eggTime;

    public BasiliskEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.eggTime = this.f_19796_.m_188503_(3000) + 3000;
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 7));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(6, 4));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    public boolean m_203441_(FluidState fluidState) {
        return this.isRunning();
    }

    @Override
    public float m_274421_() {
        return 0.4f;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        JSGroundNavigation navigation = new JSGroundNavigation(this, level);
        navigation.setCanClimb(true);
        return navigation;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.eggTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)JSV1Items.BASILISK_EGG.get());
            this.m_146850_(GameEvent.f_157810_);
            this.eggTime = this.f_19796_.m_188503_(3000) + 3000;
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("EggLayTime")) {
            this.eggTime = compound.m_128451_("EggLayTime");
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("EggLayTime", this.eggTime);
    }

    public void setClimbing(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
    }

    @Override
    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public static boolean canSpawn(EntityType<? extends Entity> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(blockPos).m_60713_(Blocks.f_50016_) && serverLevelAccessor.m_45517_(LightLayer.SKY, blockPos) > 9;
    }
}

