/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import java.util.Random;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class GoatEntity
extends JSAnimalBase {
    public static final EntityDataAccessor<Integer> goat_variant = SynchedEntityData.m_135353_(GoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GoatEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setGoatVariant(GoatType.getRandom());
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 20));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(10, 8));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null || this.getFleeTarget() != null) {
            return (SoundEvent)JSV1Sounds.GOAT_ALARM.get();
        }
        return (SoundEvent)JSV1Sounds.GOAT_LIVING.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.GOAT_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.GOAT_HURT.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(goat_variant, (Object)0);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setGoatVariant(GoatType.values()[pCompound.m_128451_("js.goat_variant")]);
    }

    public GoatType getGoatVariant() {
        return GoatType.values()[(Integer)this.f_19804_.m_135370_(goat_variant)];
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("js.goat_variant", this.getGoatVariant().ordinal());
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        Biome biomeResult;
        Holder biome = level.m_7062_().m_204214_(this.m_20183_());
        if (reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED) {
            this.setGoatVariant(GoatType.getRandom());
        }
        if ((biomeResult = (Biome)biome.m_203334_()).m_198904_(this.m_20183_())) {
            this.setGoatVariant(GoatType.JPOG);
        } else if (!biomeResult.m_264473_()) {
            this.setGoatVariant(GoatType.JURASSIC_PARK);
        } else if (biomeResult.m_47554_() >= 0.8f) {
            this.setGoatVariant(GoatType.JWE);
        } else {
            this.setGoatVariant(GoatType.JURASSIC_WORLD);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    private void setGoatVariant(GoatType random) {
        this.f_19804_.m_135381_(goat_variant, (Object)random.ordinal());
    }

    public static boolean canSpawn(EntityType<? extends Entity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean state = level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_);
        return state && GoatEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, pos);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter level, BlockPos pos) {
        return level.m_45524_(pos, 0) > 8;
    }

    public static enum GoatType {
        JURASSIC_PARK("jp"),
        JPOG("jpog"),
        JWE("jwe"),
        JURASSIC_WORLD("jw");

        private final String typeName;
        private static final Random rng;

        private GoatType(String typeName) {
            this.typeName = typeName;
        }

        public static GoatType getRandom() {
            return GoatType.values()[rng.nextInt(GoatType.values().length)];
        }

        public String getTypeName() {
            return this.typeName;
        }

        static {
            rng = new Random();
        }
    }
}

