/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class OstrichEntity
extends JSAnimalBase {
    public OstrichEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(10, 6));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 15));
    }

    @Override
    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.isStalking()) {
            return;
        }
        this.m_5496_((SoundEvent)JSSounds.SMALL_STEP.get(), 2.0f, this.m_6100_() - 0.1f);
    }

    protected float m_6059_() {
        float speed = this.m_6113_();
        return this.f_19788_ + 6.0f * speed;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        this.m_19983_(new ItemStack((ItemLike)JSV1Items.OSTRICH_EGG.get(), this.f_19796_.m_188503_(3) + 1));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null || this.getFleeTarget() != null) {
            return (SoundEvent)JSV1Sounds.OSTRICH_THREAT.get();
        }
        return (SoundEvent)JSV1Sounds.OSTRICH_IDLE.get();
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV1Sounds.OSTRICH_ATTACK.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.OSTRICH_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.OSTRICH_HURT.get();
    }

    public static boolean canSpawn(EntityType<? extends Entity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean state = level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_);
        return state && OstrichEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, pos);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter level, BlockPos pos) {
        return level.m_45524_(pos, 0) > 8;
    }
}

