/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAmphibiousBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.ReedFrogFlop;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.ReedFrogMeleeAttack;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class ReedFrogEntity
extends JSAmphibiousBase {
    public ReedFrogEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(8, 8));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 20));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new ReedFrogFlop(this));
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new ReedFrogMeleeAttack(this));
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        this.m_19983_(new ItemStack((ItemLike)JSV1Items.FROG_EGG.get(), this.f_19796_.m_188503_(3) + 1));
    }

    public static boolean canSpawn(EntityType<? extends Entity> reedFrogEntityEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return ReedFrogEntity.checkSurfaceWaterAnimalSpawnRules(reedFrogEntityEntityType, (LevelAccessor)serverLevelAccessor, mobSpawnType, blockPos, randomSource);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JSV1Sounds.REED_FROG_CALL.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.REED_FROG_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.REED_FROG_HURT.get();
    }

    @Override
    public boolean shouldDieInstantly() {
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    @Override
    protected boolean sinkToBottom() {
        return false;
    }

    @Override
    public boolean shallowSwimming() {
        return true;
    }

    @Override
    protected boolean usesAir() {
        return false;
    }
}

