/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSCrablikeAnimal;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MesolimulusPathTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class MesolimulusEntity
extends JSCrablikeAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(MesolimulusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLIPPED = SynchedEntityData.m_135353_(MesolimulusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int flipTicks = 0;
    private int unflipTicks = 0;

    public MesolimulusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        SoundType soundtype = state.m_60827_();
        this.m_5496_((SoundEvent)JSV1Sounds.MESOLIMLUS_WALK.get(), this.m_6121_(), soundtype.m_56774_());
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new MesolimulusPathTask(this).setRange(8, 12));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 20));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.flipTicks > 0) {
            --this.flipTicks;
        }
        if (this.unflipTicks > 0) {
            --this.unflipTicks;
        }
        if (this.m_20096_() && !this.m_20069_()) {
            if (this.isFlipped() && this.isMoving()) {
                this.navigationController.stop();
            }
            if (!this.isFlipped()) {
                if (this.f_19796_.m_188501_() < 5.0E-4f) {
                    this.navigationController.stop();
                    this.flip();
                }
            } else {
                List list = this.m_9236_().m_45971_(MesolimulusEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(1.5));
                if (!list.isEmpty()) {
                    if (this.f_19796_.m_188501_() < 0.5f) {
                        this.unflip();
                    }
                } else if (this.f_19796_.m_188501_() < 5.0E-4f) {
                    this.unflip();
                }
            }
        }
        if (this.isFlipped() && this.m_20069_()) {
            this.unflip();
        }
    }

    public boolean isFlipped() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLIPPED);
    }

    private void flip() {
        this.flipTicks = 20;
        this.f_19804_.m_135381_(IS_FLIPPED, (Object)true);
    }

    private void unflip() {
        this.unflipTicks = 20;
        this.f_19804_.m_135381_(IS_FLIPPED, (Object)false);
    }

    @Override
    protected boolean usesAir() {
        return false;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.f_19804_.m_135381_(IS_FLIPPED, (Object)pCompound.m_128471_("js.isFlipped"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128379_("js.isFlipped", this.isFlipped());
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_FLIPPED, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(this.checkFlipInteract(pPlayer, pHand));
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (amount > 0.0f && (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_)) && this.flipTicks == 0 && this.m_217043_().m_188501_() < 0.2f && !this.isDead()) {
            if (this.isFlipped()) {
                this.unflip();
            } else {
                this.flip();
            }
        }
        return super.m_6469_(source, amount);
    }

    private InteractionResult checkFlipInteract(Player pPlayer, InteractionHand pHand) {
        if (this.isFlipped()) {
            this.unflip();
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    protected boolean sinkToBottom() {
        return true;
    }

    public void m_6872_(@NotNull ItemStack pStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)pStack);
    }

    public void m_142278_(@NotNull CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    public ItemStack m_28282_() {
        return ((Item)this.getAnimal().getItems().getBucket().get()).m_7968_();
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JSV1Sounds.MESOLIMLUS_LIVING.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.MESOLIMLUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.MESOLIMLUS_DEATH.get();
    }

    @Override
    protected double getSinkRate() {
        return 0.02f;
    }
}

