/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAmphibiousNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.AquaticCombatFollow;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.LeapOutOfWaterTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.TyloMoveToWaterTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersAmphibiousMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class TylosaurusEntity
extends JSAquaticBase
implements IJSLeapingEntity {
    public static final EntityDataAccessor<Boolean> leaping = SynchedEntityData.m_135353_(TylosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public TylosaurusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.moveController = new TravelersAmphibiousMoveControl((SmartAnimalBase)this, 20, 20, 1.0f, 0.2f);
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return new JSAmphibiousNavigation(this, level, false);
    }

    @Override
    protected void handleAirSupply(int airSupply) {
        this.m_20301_(300);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JSV1Sounds.TYLOSAURUS_LIVING.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.TYLOSAURUS_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.TYLOSAURUS_HURT.get();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(32, 16).setYVariation(8));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new TyloMoveToWaterTask(this));
        controller.registerTask((TravelerTaskBase)new AquaticCombatFollow(this));
        controller.registerTask((TravelerTaskBase)new LeapOutOfWaterTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 15;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(leaping, (Object)false);
    }

    @Override
    protected double getUpLift() {
        return 0.035;
    }

    @Override
    public void actuallyAttack(LivingEntity target) {
        super.actuallyAttack(target);
        this.doSweepAttack((Entity)this, 5.0f, 6.0f, this.m_20205_());
    }

    public void doSweepAttack(Entity attacker, float width, float height, float depth) {
        Vec3 look = attacker.m_20154_().m_82541_();
        Vec3 center = attacker.m_20182_().m_82549_(look.m_82490_((double)(depth / 2.0f))).m_82520_(0.0, (double)(attacker.m_20206_() / 2.0f), 0.0);
        AABB hitbox = new AABB(center.f_82479_ - (double)(width / 2.0f), center.f_82480_ - (double)(height / 2.0f), center.f_82481_ - (double)(width / 2.0f), center.f_82479_ + (double)(width / 2.0f), center.f_82480_ + (double)(height / 2.0f), center.f_82481_ + (double)(width / 2.0f));
        List targets = attacker.m_9236_().m_6443_(LivingEntity.class, hitbox, e -> e != attacker);
        for (LivingEntity target : targets) {
            if (target.m_6095_() == this.m_6095_()) continue;
            this.m_7327_((Entity)target);
        }
    }

    @Override
    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(leaping);
    }

    @Override
    public void setLeaping(boolean isLeaping) {
        this.f_19804_.m_135381_(leaping, (Object)isLeaping);
    }

    @Override
    public void onLeap() {
    }
}

