/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.avian;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAquaticNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MeganeuraFloatTask;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MeganeuraFoodTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersSmoothSwimMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class MeganeuraEntity
extends JSAvianBase {
    private JSAquaticNavigation aquaticNavigation;
    private TravelersSmoothSwimMoveControl aquaticControl;

    public MeganeuraEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
        this.setPathfindingMalus(TravelersPathType.WATER_BORDER, 0.0f);
    }

    @Override
    protected void actuallyAttack(LivingEntity pendingTarget) {
        super.actuallyAttack(pendingTarget);
        this.getModules().getMetabolismModule().addFood(500);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 20));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this));
        controller.registerTask((TravelerTaskBase)new MeganeuraFloatTask(this));
        controller.registerTask((TravelerTaskBase)new MeganeuraFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSCombatFollowTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, false));
    }

    @Override
    public int getDistanceOfGround() {
        return 5;
    }

    @Override
    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_20069_() && this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            if (!this.m_9236_().f_46443_ && this.m_20069_()) {
                this.m_19920_(this.m_6113_(), travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.6));
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            } else {
                super.m_7023_(travelVector);
            }
            return;
        }
        super.m_7023_(travelVector);
    }

    @Override
    public void onGrowthStageChange(AnimalGrowthStage newStage) {
        if (newStage == AnimalGrowthStage.ADULT) {
            this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
        }
        super.onGrowthStageChange(newStage);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.isFlying() && !this.m_6162_()) {
            return (SoundEvent)JSV1Sounds.MEGANEURA_FLIGHT_LOOP.get();
        }
        return null;
    }

    public int m_20146_() {
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT ? super.m_20146_() : this.m_6062_();
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    public boolean m_6063_() {
        return this.isDead() && this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT;
    }

    @Override
    public boolean disableFlyTransitions() {
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
            if ((double)this.getPathfindingMalus(TravelersPathType.WATER) != 0.0) {
                this.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
            }
            if (this.aquaticNavigation == null) {
                this.aquaticNavigation = new JSAquaticNavigation(this, this.m_9236_(), false);
            }
            if (this.navigationController != this.aquaticNavigation) {
                this.f_19804_.m_135381_(FLYING, (Object)false);
                this.navigationController = this.aquaticNavigation;
            }
            if (this.aquaticControl == null) {
                this.aquaticControl = new TravelersSmoothSwimMoveControl((SmartAnimalBase)this, 85.0f, 10.0f, 0.02f, 0.1f, true);
            }
            if (this.moveController != this.aquaticControl) {
                this.moveController = this.aquaticControl;
            }
        } else if (this.aquaticNavigation != null || this.aquaticControl != null) {
            this.aquaticNavigation = null;
            this.aquaticControl = null;
            this.moveController = this.flyingMoveControl;
            this.navigationController = this.getFlyingPathNavigation();
        } else {
            if (this.getPathfindingMalus(TravelersPathType.WATER) != -1.0f) {
                this.setPathfindingMalus(TravelersPathType.WATER, -1.0f);
            }
            if (this.m_20096_() && this.f_19796_.m_188501_() > 0.887f) {
                this.stamina = 1.0f;
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (!this.m_204029_(FluidTags.f_13131_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.0225, 0.0));
            }
            TravelersPathNavigation navigator = this.getNavigationController();
            TravelersPath path = navigator.getPath();
            if (this.m_20069_() || this.f_19800_) {
                if (this.checkForCollide()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0225, 0.0));
                }
                if (path != null && !path.isDone()) {
                    BlockPos nextPos = path.getNextNodePos();
                    if (navigator.isStuck()) {
                        navigator.stop();
                    }
                    int y = nextPos.m_123342_();
                    int difference = y - this.m_146904_();
                    if (y > this.m_146904_()) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, difference > 1 ? this.getUpLift() * 2.0 : this.getUpLift(), 0.0));
                    } else if (y < this.m_146904_()) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, difference > -1 ? -this.getUpLift() * 2.0 : -this.getUpLift(), 0.0));
                    }
                    this.m_21563_().m_24964_(nextPos.m_252807_());
                }
            }
        }
    }

    @Override
    protected boolean hoversInPlace() {
        return true;
    }

    protected float m_6108_() {
        return this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT ? 0.1f : 0.8f;
    }

    private double getUpLift() {
        return 0.02;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.MEGANEURA_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.MEGANEURA_DEATH.get();
    }
}

