/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSGrazeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class ApatosaurusEntity
extends JSAnimalBase {
    public ApatosaurusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 50));
        controller.registerTask((TravelerTaskBase)new JSGrazeTask(this).setMaxGrazeDuration(100));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(22, 16));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this).setRange(256));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
    }

    @Override
    public int shakeLength() {
        return 10;
    }

    @Override
    public float shakeAmount() {
        return 1.0f;
    }

    @Override
    public float shakeDistance() {
        return 60.0f;
    }

    @Override
    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.isStalking()) {
            return;
        }
        if (this.getRenderScale() > 2.0f) {
            this.m_5496_((SoundEvent)JSSounds.BIG_STEP.get(), 4.0f, this.m_6100_());
            this.shakeCamera(this.getModules().getGrowthStageModule().getPercentage(), true);
        } else {
            super.m_7355_(pos, state);
        }
    }

    @Override
    public float m_274421_() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.BABY) {
            return Mth.m_14179_((float)this.getModules().getGrowthStageModule().getPercentage(), (float)1.0f, (float)2.0f);
        }
        return 1.0f;
    }

    @Override
    protected int attackAnimLength() {
        return 30;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JSV1Sounds.APATOSAURUS_LIVING.get();
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV1Sounds.APATOSAURUS_TAIL_STRIKE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV1Sounds.APATOSAURUS_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.APATOSAURUS_HURT.get();
    }
}

