/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersSoundAnimationDefinition;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSAnimalRoarAttack
extends JSHerdCombatFollowTask {
    private final TravelersSoundAnimationDefinition soundAnimDef;
    private boolean isRoaring;
    private int roarTickOffset = 0;
    private int roarLength = 0;
    private boolean hasEnteredShake;
    private boolean scaresNearby;

    public JSAnimalRoarAttack(JSAnimalBase baseAnimal, TravelersSoundAnimationDefinition roarAnim, boolean scaresNearby) {
        super(baseAnimal);
        this.soundAnimDef = roarAnim;
        this.scaresNearby = scaresNearby;
    }

    @Override
    protected void switchState(JSHerdCombatFollowTask.State state, JSHerdCombatFollowTask.State newState) {
        super.switchState(state, newState);
        if (newState == JSHerdCombatFollowTask.State.AGGRESSIVE && !this.animal.m_5912_()) {
            this.isRoaring = this.random.nextBoolean();
            if (this.animal.m_20069_() && !(this.animal instanceof JSAquaticBase)) {
                this.isRoaring = false;
            }
            if (this.isRoaring && !this.isTargetRunningAway(this.animal.m_5448_()) && this.animal.m_21188_() == null) {
                this.roarTickOffset = this.soundAnimDef.length() - this.soundAnimDef.offset();
                this.roarLength = this.soundAnimDef.length();
                if (this.roarTickOffset == this.roarLength) {
                    this.animal.m_5496_(this.soundAnimDef.event(), 6.0f, 1.0f);
                    if (this.scaresNearby) {
                        for (JSAnimalBase animalBase : this.animal.m_9236_().m_6443_(JSAnimalBase.class, this.animal.m_20191_().m_82400_(30.0), e -> e.m_20206_() + e.m_20205_() < this.animal.m_20206_() + this.animal.m_20205_())) {
                            animalBase.setFleeTarget((Entity)this.animal);
                        }
                    }
                }
                this.animal.m_20256_(Vec3.f_82478_);
                this.animal.getNavigationController().stop();
                this.animal.getNavigationController().setFrozen(true);
                this.animal.f_20883_ = this.animal.m_146908_();
                this.animal.f_20885_ = this.animal.m_146908_();
                this.animal.f_19859_ = this.animal.m_146908_();
                this.animal.f_20884_ = this.animal.f_20883_;
                this.animal.f_20886_ = this.animal.f_20885_;
            }
            this.animal.m_21561_(true);
        }
    }

    @Override
    protected void tickAggresive(LivingEntity target) {
        if (this.isRoaring && this.animal.m_21188_() == null) {
            --this.roarLength;
            if (this.roarTickOffset == this.roarLength) {
                this.animal.m_9236_().m_5594_(null, this.animal.m_20183_(), this.soundAnimDef.event(), SoundSource.HOSTILE, 2.0f, 1.0f);
            }
            if (this.animal.canShake() && !this.hasEnteredShake && this.soundAnimDef.length() - this.soundAnimDef.secondaryOffset() > this.roarLength) {
                TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this.animal, (TravelersBasePacket)new TravelersShakeCamera(false, this.animal.shakeAmount() * 0.7f, this.roarLength, this.animal.shakeDistance() * 0.7f, this.animal.m_20182_().m_252839_()));
                this.hasEnteredShake = true;
            }
            this.animal.freezeAnimator();
            if (this.soundAnimDef != null && this.roarLength > 0) {
                this.soundAnimDef.def().sendForEntity((SmartAnimalBase)this.animal);
            }
            if (this.roarLength <= 0) {
                this.isRoaring = false;
                this.animal.getNavigationController().setFrozen(false);
            }
        } else {
            super.tickAggresive(target);
        }
    }
}

