/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class LeapOutOfWaterTask
extends JSCombatTaskBase {
    private State state = State.DIVE;
    private int timer = 0;
    private int cooldown = 0;

    public LeapOutOfWaterTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public TaskPriority getPriority() {
        if (this.animal.m_5448_() != null && !this.animal.m_5448_().m_204029_(FluidTags.f_13131_)) {
            return TaskPriority.HIGH;
        }
        return TaskPriority.LOW;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.m_5803_() || this.animal.isResting()) {
            return false;
        }
        if (this.cooldown > 0) {
            this.tickCooldown();
            return false;
        }
        if (this.animal.m_5448_() != null) {
            boolean eyeInWater = this.animal.m_5448_().m_204029_(FluidTags.f_13131_);
            return !eyeInWater;
        }
        return false;
    }

    public void onStart() {
        this.state = State.DIVE;
        this.timer = 0;
        this.animal.getNavigationController().stop();
        this.animal.getNavigationController().setFrozen(true);
    }

    public boolean canContinueRunning() {
        return true;
    }

    public boolean canInterrupt() {
        return false;
    }

    public void tick() {
        if (this.animal.m_5448_() == null) {
            return;
        }
        LivingEntity target = this.animal.m_5448_();
        Vec3 targetPos = target.m_20182_();
        double radius = Math.max(1.0, (double)this.animal.m_20205_() * 1.5);
        Vec3 centerTarget = targetPos.m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 offsetTarget = centerTarget.m_82520_((this.animal.m_217043_().m_188500_() - 0.5) * radius, 3.0, (this.animal.m_217043_().m_188500_() - 0.5) * radius);
        int depthAbove = this.getWaterDepthAbove();
        int depth = this.getWaterDepth();
        Vec3 delta = target.m_20182_().m_82546_(this.animal.m_20182_());
        double distanceTo = delta.m_82553_();
        double maxUpward = 2.5;
        double horizontalSpeed = 0.6;
        double gravity = 0.08;
        double maxHeight = maxUpward * maxUpward / (2.0 * gravity);
        double maxReach = horizontalSpeed * Math.sqrt(2.0 * maxHeight / gravity);
        if (delta.f_82480_ > maxHeight || Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_) > maxReach) {
            this.stop();
            return;
        }
        if (this.state == State.DIVE && depthAbove >= 6) {
            this.state = State.CHARGE;
            this.timer = 0;
            this.animal.setLeaping(true);
        }
        switch (this.state) {
            case DIVE: {
                ++this.timer;
                if (depth < 3) {
                    this.stop();
                    return;
                }
                this.animal.m_20334_(this.animal.m_20184_().f_82479_ * 0.8, -0.25, this.animal.m_20184_().f_82481_ * 0.8);
                this.animal.m_7618_(EntityAnchorArgument.Anchor.EYES, offsetTarget);
                if (this.timer <= 15) break;
                this.state = State.CHARGE;
                this.timer = 0;
                break;
            }
            case CHARGE: {
                ++this.timer;
                Vec3 dir = offsetTarget.m_82546_(this.animal.m_20182_()).m_82541_();
                double accel = Math.min(0.15 + (double)this.timer * 0.02, 0.6);
                Vec3 vel = this.animal.m_20184_().m_82549_(dir.m_82490_(accel));
                vel = new Vec3(vel.f_82479_, Math.min(vel.f_82480_, maxUpward), vel.f_82481_);
                this.animal.m_20256_(vel);
                this.animal.m_7618_(EntityAnchorArgument.Anchor.EYES, offsetTarget);
                float targetYaw = (float)(Mth.m_14136_((double)vel.f_82481_, (double)vel.f_82479_) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(Mth.m_14136_((double)vel.f_82480_, (double)Math.sqrt(vel.f_82479_ * vel.f_82479_ + vel.f_82481_ * vel.f_82481_)) * 57.29577951308232));
                this.animal.m_146922_(Mth.m_14179_((float)0.2f, (float)this.animal.m_146908_(), (float)targetYaw));
                this.animal.m_146926_(Mth.m_14179_((float)0.2f, (float)this.animal.m_146909_(), (float)targetPitch));
                this.animal.f_20883_ = this.animal.m_146908_();
                this.animal.f_20885_ = this.animal.m_146908_();
                if (this.animal.m_20280_((Entity)target) < (double)((this.animal.m_20205_() + 2.0f) * (this.animal.m_20205_() + 2.0f))) {
                    this.animal.m_7327_((Entity)target);
                    this.stop();
                    return;
                }
                int maxChargeTime = Math.min(30 + depthAbove * 2, 60);
                if (!(vel.f_82480_ > 1.2) && this.timer <= maxChargeTime) break;
                this.state = State.LAUNCH;
                break;
            }
            case LAUNCH: {
                this.animal.setLeaping(true);
                Vec3 vel = this.animal.m_20184_();
                float targetYaw = (float)(Mth.m_14136_((double)vel.f_82481_, (double)vel.f_82479_) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(Mth.m_14136_((double)vel.f_82480_, (double)Math.sqrt(vel.f_82479_ * vel.f_82479_ + vel.f_82481_ * vel.f_82481_)) * 57.29577951308232));
                this.animal.m_146922_(Mth.m_14179_((float)0.2f, (float)this.animal.m_146908_(), (float)targetYaw));
                this.animal.m_146926_(Mth.m_14179_((float)0.2f, (float)this.animal.m_146909_(), (float)targetPitch));
                this.animal.f_20883_ = this.animal.m_146908_();
                this.animal.f_20885_ = this.animal.m_146908_();
                this.animal.m_7618_(EntityAnchorArgument.Anchor.EYES, offsetTarget);
                if (!this.animal.m_20069_() && !this.animal.m_20096_()) break;
                this.stop();
            }
        }
    }

    private int getWaterDepth() {
        BlockPos pos = this.animal.m_20183_();
        int depth = 0;
        for (int i = 1; i <= 20; ++i) {
            BlockPos check = pos.m_6625_(i);
            if (this.animal.m_9236_().m_8055_(check).m_60819_().m_76178_()) break;
            ++depth;
        }
        return depth;
    }

    private int getWaterDepthAbove() {
        BlockPos pos = this.animal.m_20183_();
        int depth = 0;
        for (int i = 1; i <= 20; ++i) {
            BlockPos check = pos.m_6630_(i);
            if (this.animal.m_9236_().m_8055_(check).m_60819_().m_76178_()) break;
            ++depth;
        }
        return depth;
    }

    public void onStop() {
        this.animal.setLeaping(false);
        this.animal.getNavigationController().setFrozen(false);
        this.animal.m_21561_(false);
        this.state = State.DIVE;
        this.timer = 0;
        this.cooldown = 1;
    }

    public void tickCooldown() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    private static enum State {
        DIVE,
        CHARGE,
        LAUNCH;

    }
}

