/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StegosaurTailSwipe
extends JSHerdCombatFollowTask {
    private int tailSwipeTime;
    private boolean didSwipe;

    public StegosaurTailSwipe(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    @Override
    public void tick() {
        if (this.tailSwipeTime > 0) {
            if (this.tailSwipeTime < 20 && !this.didSwipe) {
                this.didSwipe = true;
                this.doSweepAttack((Entity)this.animal, 8.0f, 6.0f, this.animal.m_20205_());
            }
            --this.tailSwipeTime;
            this.animal.stopInPlace();
        } else {
            super.tick();
        }
    }

    public boolean canInterrupt() {
        return this.tailSwipeTime == 0;
    }

    @Override
    protected void attack(LivingEntity target) {
        this.tailSwipeTime = 40;
        this.animal.curAttackTicks = 4;
        this.didSwipe = false;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.didSwipe = false;
        this.tailSwipeTime = 0;
    }

    public void doSweepAttack(Entity attacker, float width, float height, float depth) {
        Vec3 look = attacker.m_20154_().m_82541_();
        Vec3 center = attacker.m_20182_().m_82549_(look.m_82490_((double)(depth / 2.0f))).m_82520_(0.0, (double)(attacker.m_20206_() / 2.0f), 0.0);
        AABB hitbox = new AABB(center.f_82479_ - (double)(width / 2.0f), center.f_82480_ - (double)(height / 2.0f), center.f_82481_ - (double)(width / 2.0f), center.f_82479_ + (double)(width / 2.0f), center.f_82480_ + (double)(height / 2.0f), center.f_82481_ + (double)(width / 2.0f));
        List targets = attacker.m_9236_().m_6443_(LivingEntity.class, hitbox, e -> e.m_6095_() != attacker.m_6095_());
        for (LivingEntity target : targets) {
            this.animal.m_7327_((Entity)target);
            Vec3 attackerAngle = attacker.m_20154_().m_82541_();
            double strength = 1.0;
            target.m_5997_(attackerAngle.f_82479_ * strength, 0.3, attackerAngle.f_82481_ * strength);
        }
    }
}

