/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSPlantData;
import jp.jurassicsaga.server.base.item.obj.egg.FertileEggItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.CultivatorMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CultivatorMachineEntity
extends GenericMachineEntity {
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 1 -> CultivatorMachineEntity.this.progress1;
                case 2 -> CultivatorMachineEntity.this.progress2;
                case 3 -> CultivatorMachineEntity.this.progress3;
                default -> 60000;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 1: {
                    CultivatorMachineEntity.this.progress1 = value;
                    break;
                }
                case 2: {
                    CultivatorMachineEntity.this.progress2 = value;
                    break;
                }
                case 3: {
                    CultivatorMachineEntity.this.progress3 = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final int maxProgress = 60000;
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;

    public CultivatorMachineEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(19, (Block)JSV1Blocks.CULTIVATOR.get(), (BlockEntityType)JSV1BlockEntities.CULTIVATOR.get(), p_155229_, p_155230_);
    }

    private void tickItem(int slot, Level lvl, CultivatorMachineEntity be) {
        ItemStack slot1 = (ItemStack)be.items.get(slot);
        if (lvl.f_46443_) {
            return;
        }
        int speed = lvl.m_46469_().m_46215_(JSCommon.MACHINE_SPEED);
        Item item = slot1.m_41720_();
        if (item instanceof FertileEggItem) {
            FertileEggItem eggItem = (FertileEggItem)item;
            int progressCur = switch (slot) {
                case 0 -> be.progress1;
                case 1 -> be.progress2;
                case 2 -> be.progress3;
                default -> 0;
            };
            CompoundTag tag = slot1.m_41784_();
            CompoundTag animal = tag.m_128469_("jsGeneData");
            if (animal.m_128456_()) {
                return;
            }
            JSGeneData geneData = JSGeneUtil.fromCompound(animal);
            ResourceLocation name = ResourceLocation.m_135822_((String)geneData.getDataOwnerName(), (char)':');
            JSPlantData plantData = JSGenetics.PLANT_GENETIC_INFORMATION.get(name.m_135815_());
            if (plantData == null) {
                progressCur = 0;
            } else if ((progressCur += speed) >= be.maxProgress) {
                JSGeneData data = JSGeneUtil.readFromStack(slot1);
                ItemStack output = ((Block)plantData.result.get()).m_5456_().m_7968_();
                output.m_41764_(2);
                if (data.isValid()) {
                    JSGeneUtil.writeToStack(output, data);
                }
                be.items.set(slot, (Object)output);
                progressCur = 0;
            }
            switch (slot) {
                case 0: {
                    be.progress1 = progressCur;
                    break;
                }
                case 1: {
                    be.progress2 = progressCur;
                    break;
                }
                case 2: {
                    be.progress3 = progressCur;
                }
            }
        } else {
            switch (slot) {
                case 0: {
                    be.progress1 = 0;
                    break;
                }
                case 1: {
                    be.progress2 = 0;
                    break;
                }
                case 2: {
                    be.progress3 = 0;
                }
            }
        }
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("js.egg.0", this.progress1);
        tag.m_128405_("js.egg.1", this.progress2);
        tag.m_128405_("js.egg.2", this.progress3);
        return tag;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, @NotNull Inventory p_39955_, @NotNull Player p_39956_) {
        return new CultivatorMachineMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("js.egg.0", this.progress1);
        tag.m_128405_("js.egg.1", this.progress2);
        tag.m_128405_("js.egg.2", this.progress3);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress1 = tag.m_128451_("js.egg.0");
        this.progress2 = tag.m_128451_("js.egg.1");
        this.progress3 = tag.m_128451_("js.egg.2");
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (!(be instanceof CultivatorMachineEntity)) {
            return;
        }
        CultivatorMachineEntity e = (CultivatorMachineEntity)be;
        this.localTick(level, e);
    }

    public void localTick(Level lvl, CultivatorMachineEntity be) {
        be.m_6596_();
        be.tickItem(0, lvl, be);
        be.tickItem(1, lvl, be);
        be.tickItem(2, lvl, be);
        be.m_6596_();
    }
}

