/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.AnimalAttachment;
import jp.jurassicsaga.server.base.item.obj.egg.BasicSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneItem;
import jp.jurassicsaga.server.base.item.obj.genetics.GeneticsItem;
import jp.jurassicsaga.server.base.item.obj.genetics.OtherDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.DnaModifierMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnaModifierMachineEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private ItemStack result = ItemStack.f_41583_;
    private int progress = 0;
    private int maxProgress = 6500;
    private boolean hasInitialized;

    public DnaModifierMachineEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(20, (Block)JSV1Blocks.DNA_MODIFIER.get(), (BlockEntityType)JSV1BlockEntities.DNA_MODIFIER.get(), p_155229_, p_155230_);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> DnaModifierMachineEntity.this.progress;
                    case 1 -> DnaModifierMachineEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        DnaModifierMachineEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        DnaModifierMachineEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
        this.init();
    }

    @Override
    public void drops() {
        if (this.f_58857_ != null) {
            for (int i = 0; i < 3; ++i) {
                ItemStack item = (ItemStack)this.items.get(i);
                Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)item);
            }
        }
    }

    public void init() {
    }

    /*
     * Unable to fully structure code
     */
    public void localTick(Level lvl, DnaModifierMachineEntity be) {
        block13: {
            block14: {
                block16: {
                    block15: {
                        upperSlot = (ItemStack)be.items.get(0);
                        lowerSlot = (ItemStack)be.items.get(1);
                        if (lvl.f_46443_) break block13;
                        speed = lvl.m_46469_().m_46215_(JSCommon.MACHINE_SPEED);
                        if (!upperSlot.m_41619_() && lowerSlot.m_41619_() && !this.hasInitialized) {
                            tag = upperSlot.m_41784_();
                            animalData = tag.m_128469_("jsGeneData");
                            if (!animalData.m_128456_()) {
                                dna = JSGeneUtil.fromCompound(animalData);
                                startSlot = 3;
                                hasCosmetics = false;
                                for (i = 0; i < dna.geneDataHolder.getGENE_SET().size(); ++i) {
                                    gene = dna.geneDataHolder.getGENE_SET().get(i);
                                    item = JSGenetics.GENE_ITEMS.get(gene);
                                    if (gene instanceof JSCosmeticGene) {
                                        hasCosmetics = true;
                                        this.items.set(10, (Object)((Item)item.get()).m_7968_());
                                        continue;
                                    }
                                    this.items.set(startSlot + (hasCosmetics != false ? -1 : 0) + i, (Object)((Item)item.get()).m_7968_());
                                }
                            }
                            this.hasInitialized = true;
                        }
                        if (lowerSlot.m_41619_()) break block13;
                        if (this.hasInitialized) {
                            for (i = 0; i < 8; ++i) {
                                this.items.set(3 + i, (Object)ItemStack.f_41583_);
                            }
                            this.hasInitialized = false;
                        }
                        if (this.result == ItemStack.f_41583_ || this.result == null) {
                            this.result = this.determineResult(be);
                            be.progress = 0;
                            return;
                        }
                        slot2 = (ItemStack)be.getItems().get(2);
                        if (slot2.m_41613_() >= slot2.m_41741_() && !slot2.m_41619_() && !ItemStack.m_150942_((ItemStack)slot2, (ItemStack)this.result)) break block14;
                        if (be.progress < this.maxProgress) break block15;
                        if (slot2.m_41619_()) {
                            be.items.set(2, (Object)this.result);
                        } else {
                            slot2.m_41769_(1);
                            be.items.set(2, (Object)slot2);
                        }
                        upperSlot.m_41774_(1);
                        lowerSlot.m_41774_(1);
                        be.progress = 0;
                        this.result = ItemStack.f_41583_;
                        break block13;
                    }
                    var8_9 = upperSlot.m_41720_();
                    if (!(var8_9 instanceof GenderSpawnEgg)) break block16;
                    egg = (GenderSpawnEgg)var8_9;
                    if (!lowerSlot.m_41619_()) ** GOTO lbl-1000
                }
                if (upperSlot.m_41720_() instanceof BasicSpawnEgg) lbl-1000:
                // 2 sources

                {
                    be.progress += speed * 5;
                } else if (!upperSlot.m_41619_() && !lowerSlot.m_41619_()) {
                    be.progress += speed;
                } else {
                    be.progress = 0;
                    this.result = ItemStack.f_41583_;
                }
                break block13;
            }
            be.progress = 0;
            this.result = ItemStack.f_41583_;
        }
        be.m_6596_();
    }

    private ItemStack determineResult(DnaModifierMachineEntity be) {
        ItemStack upperSlot = (ItemStack)be.items.get(0);
        ItemStack lowerSlot = (ItemStack)be.items.get(1);
        if (lowerSlot.m_41720_() instanceof PlantDnaItem) {
            ItemStack result = lowerSlot.m_41777_();
            result.m_41764_(1);
            Item item = upperSlot.m_41720_();
            if (item instanceof GeneItem) {
                GeneItem geneItem = (GeneItem)item;
                JSGene gene = geneItem.getGene();
                if (this.canAddGene(lowerSlot, gene)) {
                    this.addGeneToDNAResult(result, geneItem.getGene());
                    return result;
                }
            } else if (upperSlot.m_41720_() instanceof PlantDnaItem) {
                JSGeneData down = JSGeneUtil.readFromStack(lowerSlot);
                JSGeneData up = JSGeneUtil.readFromStack(upperSlot);
                if (this.isCombinationValid(up, down)) {
                    return this.getMergeDNAResult(lowerSlot, upperSlot);
                }
            }
            return ItemStack.f_41583_;
        }
        Item geneItem = lowerSlot.m_41720_();
        if (!(geneItem instanceof AnimalAttachment)) {
            return ItemStack.f_41583_;
        }
        AnimalAttachment dnaItem = (AnimalAttachment)geneItem;
        ItemStack result = lowerSlot.m_41777_();
        result.m_41764_(1);
        Item up = upperSlot.m_41720_();
        if (up instanceof GeneItem) {
            GeneItem geneItem2 = (GeneItem)up;
            JSGene gene = geneItem2.getGene();
            if (dnaItem.getAnimal().getAnimalAttributes().getGeneticProperties().isGeneSupported(gene) && this.canAddGene(lowerSlot, gene)) {
                this.addGeneToDNAResult(result, geneItem2.getGene());
                return result;
            }
        } else if (upperSlot.m_41720_() instanceof DnaItem || upperSlot.m_41720_() instanceof OtherDnaItem) {
            JSGeneData down = JSGeneUtil.readFromStack(lowerSlot);
            JSGeneData up2 = JSGeneUtil.readFromStack(upperSlot);
            if (up2.getAnimal() != null && !down.getDataOwnerName().equals(up2.getDataOwnerName()) && up2.getAnimal().getAnimalAttributes().getMiscProperties().isExtinct()) {
                return ItemStack.f_41583_;
            }
            if (this.isCombinationValid(up2, down)) {
                return this.getMergeDNAResult(lowerSlot, upperSlot);
            }
        }
        return ItemStack.f_41583_;
    }

    private boolean isCombinationValid(JSGeneData up, JSGeneData down) {
        boolean isValidCombination = false;
        if (down.getDataOwnerName().equals(up.getDataOwnerName())) {
            if (down.getBaseQuality() == 100) {
                return false;
            }
            if (down.hasDonor() && up.hasDonor() && down.getDonorName().equals(up.getDonorName()) || !down.hasDonor() && up.hasDonor() || down.hasDonor() && !up.hasDonor() || !down.hasDonor() && !up.hasDonor()) {
                isValidCombination = true;
            }
        } else {
            if (up.hasDonor()) {
                return false;
            }
            if (down.hasDonor()) {
                if (up.getDataOwnerName().equals(down.getDonorName()) && down.getTotalCompletion() < 100) {
                    isValidCombination = true;
                }
            } else if (down.isCompatibleWith(up.getDonorName())) {
                isValidCombination = true;
            }
        }
        return isValidCombination;
    }

    private ItemStack getMergeDNAResult(ItemStack lower, ItemStack upper) {
        JSGeneData upperData = JSGeneUtil.readFromStack(upper);
        JSGeneData lowerData = JSGeneUtil.readFromStack(lower);
        JSGeneData data1 = lowerData.combine(upperData);
        if (this.random.nextFloat() < 0.1f) {
            data1.addGene(JSGenetics.getRandomBadGene());
        }
        ItemStack res = new ItemStack((ItemLike)lower.m_41720_(), 1);
        JSGeneUtil.writeToStack(res, data1);
        return res;
    }

    private boolean canAddGene(ItemStack result, JSGene gene) {
        JSGeneData data = JSGeneUtil.readFromStack(result);
        return data.canAccept(gene) && data.canAddGene(gene);
    }

    private void addGeneToDNAResult(ItemStack result, JSGene gene) {
        JSGeneData data = JSGeneUtil.readFromStack(result);
        data.addGene(gene);
        JSGeneUtil.writeToStack(result, data);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, @NotNull Inventory p_39955_, @NotNull Player p_39956_) {
        return new DnaModifierMachineMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof DnaModifierMachineEntity) {
            DnaModifierMachineEntity e = (DnaModifierMachineEntity)be;
            e.localTick(level, e);
        }
    }

    public void onTookFromOutputSlot(ItemStack stack) {
        this.progress = 0;
        this.result = null;
        Item item = stack.m_41720_();
        if (item instanceof GeneItem) {
            GeneItem item2 = (GeneItem)item;
            ItemStack inputStack = (ItemStack)this.items.get(0);
            JSGene gene = item2.getGene();
            if (!inputStack.m_41619_()) {
                JSGeneData geneticData = JSGeneUtil.readFromStack(inputStack);
                geneticData.removeGene(gene);
                JSGeneUtil.wipeStack(inputStack);
                JSGeneUtil.writeToStack(inputStack, geneticData);
            }
            this.items.set(0, (Object)inputStack);
        } else if (this.hasInitialized) {
            for (int i = 0; i < 8; ++i) {
                this.items.set(3 + i, (Object)ItemStack.f_41583_);
            }
            this.hasInitialized = false;
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public boolean mayPlaceGene(JSGene gene) {
        JSAnimal<?> animal;
        JSGeneData geneData;
        ItemStack geneHolder = (ItemStack)this.items.get(0);
        if (geneHolder == null) {
            return false;
        }
        if (gene instanceof JSCosmeticGene && (geneData = JSGeneUtil.readFromStack(geneHolder)).getAnimal() != null && !(animal = geneData.getAnimal()).getAnimalAttributes().getGeneticProperties().isGeneSupported(gene)) {
            return false;
        }
        if (geneHolder.m_41720_() instanceof GeneticsItem || geneHolder.m_41720_() instanceof GenderSpawnEgg || geneHolder.m_41720_() instanceof BasicSpawnEgg) {
            geneData = JSGeneUtil.readFromStack(geneHolder);
            return geneData.canAddGene(gene);
        }
        return false;
    }

    public void addGene(JSGene gene) {
        JSGeneData geneData;
        if (gene == null) {
            if (this.hasInitialized) {
                for (int i = 0; i < 8; ++i) {
                    this.items.set(3 + i, (Object)ItemStack.f_41583_);
                }
                this.hasInitialized = false;
            }
            return;
        }
        ItemStack geneHolder = (ItemStack)this.items.get(0);
        if (geneHolder == null) {
            return;
        }
        if ((geneHolder.m_41720_() instanceof GeneticsItem || geneHolder.m_41720_() instanceof GenderSpawnEgg || geneHolder.m_41720_() instanceof BasicSpawnEgg) && (geneData = JSGeneUtil.readFromStack(geneHolder)).canAddGene(gene)) {
            geneData.addGene(gene);
            JSGeneUtil.wipeStack(geneHolder);
            JSGeneUtil.writeToStack(geneHolder, geneData);
        }
    }
}

