/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import java.util.Objects;
import java.util.Random;
import jp.jurassicsaga.server.util.JSHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class GenericMachineEntity
extends BlockEntity
implements MenuProvider {
    public final int SLOT_COUNT;
    protected NonNullList<ItemStack> items;
    private final Block block;
    private boolean blockUpdate;
    private int animTickDelay = 20;
    protected final Random random = new Random();

    public GenericMachineEntity(int slots, Block block, BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.SLOT_COUNT = slots;
        this.block = block;
        this.items = NonNullList.m_122780_((int)this.SLOT_COUNT, (Object)ItemStack.f_41583_);
    }

    protected void playSound(BlockState state, SoundEvent sound) {
        double x = (double)this.f_58858_.m_123341_() + 0.5;
        double y = (double)this.f_58858_.m_123342_() + 0.5;
        double z = (double)this.f_58858_.m_123343_() + 0.5;
        float volume = 0.5f;
        assert (this.f_58857_ != null);
        float pitch = 1.5f;
        this.f_58857_.m_6263_(null, x, y, z, sound, SoundSource.BLOCKS, volume, pitch);
    }

    public abstract ContainerData getContainerData();

    protected void animate(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.SLOT_COUNT, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        return tag;
    }

    public void drops() {
        if (this.f_58857_ != null) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, this.items);
        }
    }

    @NotNull
    public Component m_5446_() {
        return this.block.m_49954_();
    }

    public abstract void workTick(Level var1, GenericMachineEntity var2, BlockState var3, BlockPos var4);

    public final void tick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be.f_58857_ == null) {
            return;
        }
        this.workTick(level, be, state, pos);
        if (this.animTickDelay > 0) {
            --this.animTickDelay;
        } else {
            this.animate(level, be, state, pos);
        }
        if (level != null && this.blockUpdate) {
            level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.m_58904_() != null && !this.isSilent()) {
            this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    protected boolean isSilent() {
        return false;
    }

    public void playSound(SoundEvent sound) {
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), this.getPitch());
        }
    }

    protected float getPitch() {
        return (Objects.requireNonNull(this.f_58857_).m_213780_().m_188501_() - this.f_58857_.m_213780_().m_188501_()) * 0.2f + 1.0f;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected void spawnParticle(ParticleOptions options, int count, float xf, float yf, float zf, float speed) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Vec3 center = this.m_58899_().m_252807_();
            server.m_8767_(options, center.m_7096_(), center.m_7098_(), center.m_7094_(), count, (double)xf, (double)yf, (double)zf, (double)speed);
        }
    }

    public boolean canAddItem(ItemStack stack) {
        int remaining = stack.m_41613_();
        for (ItemStack itemstack : this.items) {
            int space;
            if (itemstack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack) || (remaining -= (space = itemstack.m_41741_() - itemstack.m_41613_())) > 0) continue;
            return true;
        }
        return false;
    }

    public void openMenu(@NotNull Player player) {
        JSHelper.jsPlatform.openMenu(player, this.m_58899_(), this);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isBlockUpdate() {
        return this.blockUpdate;
    }

    public void setBlockUpdate(boolean blockUpdate) {
        this.blockUpdate = blockUpdate;
    }
}

