/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.GeneType;
import jp.jurassicsaga.server.base.generic.gene.obj.JSDefaultEntityData;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.gene.obj.good.JSPlantData;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.ResultType;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;
import jp.jurassicsaga.server.base.item.obj.FossilItem;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalRemains;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.PlantDnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.GeneticAnalyzerMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.misc.AnimalType;

public class GeneticAnalyzerMachineEntity
extends GenericMachineEntity
implements WorldlyContainer {
    private final ContainerData data;
    private static final HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> resultPossibilityHashMap = new HashMap();
    private ItemStack currentAnalyzerItem = ItemStack.f_41583_;
    private int currentAnalyzingSlotIndex = -1;
    private int progress = 0;
    private int maxProgress = 5000;
    private ItemStack resultItem = ItemStack.f_41583_;

    public GeneticAnalyzerMachineEntity(BlockPos pos, BlockState state) {
        super(19, (Block)JSV1Blocks.GENETIC_ANALYZER.get(), (BlockEntityType)JSV1BlockEntities.GENETIC_ANALYZER.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> GeneticAnalyzerMachineEntity.this.progress;
                    case 1 -> GeneticAnalyzerMachineEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        GeneticAnalyzerMachineEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        GeneticAnalyzerMachineEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
        if (resultPossibilityHashMap.isEmpty()) {
            GeneticAnalyzerMachineEntity.init();
        }
    }

    private static void init() {
        JSGenetics.PLANT_GENETIC_INFORMATION.forEach((string, jsPlantData) -> {
            resultPossibilityHashMap.putIfAbsent(ResultType.PLANT, new HashMap());
            HashMap resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.PLANT, new HashMap());
            for (Era supportedEra : jsPlantData.supported_eras) {
                ArrayList<AnalyzerResult> list = resultHashMap.getOrDefault((Object)supportedEra, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)jsPlantData.coin.get(), 15), new AnalyzerChanceItem(Items.f_41832_, 30), new AnalyzerChanceItem(Items.f_41830_, 10), new AnalyzerChanceItem(Items.f_42413_, 20)));
                resultHashMap.put(supportedEra, list);
            }
            resultPossibilityHashMap.put(ResultType.PLANT, resultHashMap);
        });
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            ArrayList<AnalyzerResult> list;
            HashMap resultHashMap;
            if (!animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getItems().getCoin() == null) continue;
            AnimalType type = animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            Era era = animal.getAnimalAttributes().getMiscProperties().getEra();
            if (type == AnimalType.AQUATIC_MAMMAL || type == AnimalType.AQUATIC_REPTILE || type == AnimalType.FISH || type == AnimalType.AMPHIBIAN) {
                resultPossibilityHashMap.putIfAbsent(ResultType.AQUATIC, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.AQUATIC, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.f_41832_, 15), new AnalyzerChanceItem(Items.f_41830_, 10), new AnalyzerChanceItem(Items.f_42413_, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else if (type == AnimalType.SYNAPSID || type == AnimalType.INSECT || type == AnimalType.CEPHALOPOD) {
                resultPossibilityHashMap.putIfAbsent(ResultType.BUG, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.BUG, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.f_41832_, 15), new AnalyzerChanceItem(Items.f_42329_, 10), new AnalyzerChanceItem(Items.f_42413_, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else {
                resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
                resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.f_41832_, 15), new AnalyzerChanceItem(Items.f_42594_, 10), new AnalyzerChanceItem(Items.f_42413_, 20)));
                resultHashMap.put(era, list);
                resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
            }
            if (type != AnimalType.AMPHIBIAN) continue;
            resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
            resultHashMap = resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
            list = resultHashMap.getOrDefault((Object)era, new ArrayList());
            list.add(new AnalyzerResult(new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 30), new AnalyzerChanceItem(Items.f_41832_, 15), new AnalyzerChanceItem(Items.f_42594_, 10), new AnalyzerChanceItem(Items.f_42413_, 20)));
            resultHashMap.put(era, list);
            resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
        }
    }

    public void localTick(Level level) {
        block5: {
            block6: {
                int speed;
                block4: {
                    if (level.f_46443_) {
                        return;
                    }
                    speed = level.m_46469_().m_46215_(JSCommon.MACHINE_SPEED);
                    if (this.currentAnalyzingSlotIndex != -1 && !this.currentAnalyzerItem.m_41619_()) break block4;
                    this.progress = 0;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = (ItemStack)this.getItems().get(i);
                        if (!this.isValidItem(stack)) continue;
                        this.currentAnalyzerItem = stack;
                        this.currentAnalyzingSlotIndex = i;
                        this.progress = 0;
                        this.resultItem = ItemStack.f_41583_;
                        return;
                    }
                    break block5;
                }
                if (!this.resultItem.m_41619_()) break block6;
                this.progress += speed;
                if (this.progress < this.maxProgress) break block5;
                this.createResult(level);
                this.progress = 0;
                break block5;
            }
            for (int i = 9; i < 19; ++i) {
                ItemStack slotStack = (ItemStack)this.getItems().get(i);
                if (slotStack.m_41619_()) {
                    this.getItems().set(i, (Object)this.resultItem.m_41777_());
                    this.consumeInput();
                    return;
                }
                if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)this.resultItem) || slotStack.m_41613_() + this.resultItem.m_41613_() > slotStack.m_41741_()) continue;
                slotStack.m_41769_(this.resultItem.m_41613_());
                this.consumeInput();
                return;
            }
        }
    }

    private void consumeInput() {
        this.currentAnalyzerItem.m_41774_(1);
        if (this.currentAnalyzerItem.m_41619_()) {
            this.currentAnalyzerItem = ItemStack.f_41583_;
            this.currentAnalyzingSlotIndex = -1;
        }
        this.resultItem = ItemStack.f_41583_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createResult(Level level) {
        Item tag;
        Supplier<Item> coin;
        Item item = this.currentAnalyzerItem.m_41720_();
        if (item instanceof AnimalRemains) {
            AnimalRemains remains = (AnimalRemains)item;
            coin = remains.getAnimal().getItems().getCoin();
            JSAnimal<?> animal = remains.getAnimal();
            if (coin == null) return;
            JSGeneData genes = animal.getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
            this.resultItem = new ItemStack((ItemLike)coin.get());
            genes.setBaseQuality(this.random.nextInt(30) + 30);
            genes.setDataOwnerName(animal.getAnimalAttributes().getModId() + ":" + animal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT));
            JSGeneUtil.writeToStack(this.resultItem, genes);
            return;
        }
        coin = this.currentAnalyzerItem.m_41720_();
        if (coin instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)coin;
            tag = this.currentAnalyzerItem.m_41784_();
            if (tag.m_128456_()) {
                return;
            }
            int data = tag.m_128451_("CustomModelData");
            boolean isPlant = false;
            if (data != 0) {
                isPlant = data == SampleColour.PLANT.model();
            }
            String component = tag.m_128461_("entity_name");
            if (isPlant) {
                Supplier<Item> coin2;
                JSPlantData plantData = JSGenetics.PLANT_GENETIC_INFORMATION.get(ResourceLocation.m_135822_((String)component, (char)':').m_135815_());
                if (plantData == null || (coin2 = plantData.coin) == null) return;
                this.resultItem = ((Item)coin2.get()).m_7968_();
                return;
            }
            if (component.contains("minecraft:")) {
                try {
                    Supplier<Item> coin3;
                    EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.m_135822_((String)component, (char)':'));
                    JSDefaultEntityData geneData = JSGenetics.ENTITY_DEFAULT_GENE_DATA.get(entityType);
                    if (geneData == null || (coin3 = geneData.coin()) == null) return;
                    this.resultItem = new ItemStack((ItemLike)coin3.get());
                    JSGeneUtil.writeToStack(this.resultItem, geneData.geneData());
                    return;
                }
                catch (Exception e) {
                    return;
                }
            } else {
                JSAnimal<?> animal = JSAnimals.getAnimal(component);
                if (animal == null || animal.getItems().getCoin() == null) return;
                Item coin4 = (Item)animal.getItems().getCoin().get();
                JSGeneData genes = animal.getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                this.resultItem = new ItemStack((ItemLike)coin4);
                genes.setDataOwnerName(animal.getAnimalAttributes().getModId() + ":" + animal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT));
                JSGeneUtil.writeToStack(this.resultItem, genes);
            }
            return;
        }
        tag = this.currentAnalyzerItem.m_41720_();
        if (!(tag instanceof FossilItem)) {
            return;
        }
        FossilItem fossilItem = (FossilItem)tag;
        ResultType type = fossilItem.getResult().getResultType();
        ArrayList<AnalyzerResult> results = resultPossibilityHashMap.get((Object)type).get((Object)fossilItem.getEra());
        if (results == null || results.isEmpty()) {
            return;
        }
        AnalyzerResult result = results.get(level.f_46441_.m_188503_(results.size()));
        int totalWeight = 0;
        for (AnalyzerChanceItem item2 : result.getChanceItems()) {
            totalWeight += item2.chance();
        }
        int roll = level.f_46441_.m_188503_(totalWeight);
        int sum = 0;
        for (AnalyzerChanceItem item3 : result.getChanceItems()) {
            Object geneData;
            if (roll >= (sum += item3.chance())) continue;
            this.resultItem = new ItemStack((ItemLike)item3.item());
            Item item4 = item3.item();
            if (item4 instanceof DnaItem) {
                DnaItem dnaItem = (DnaItem)item4;
                geneData = dnaItem.getAnimal().getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                JSGeneData newData = ((JSGeneData)geneData).copy();
                newData.setBaseQuality(this.random.nextInt(20, 40));
                JSGeneUtil.writeToStack(this.resultItem, newData);
                return;
            }
            geneData = item3.item();
            if (!(geneData instanceof PlantDnaItem)) return;
            PlantDnaItem dnaItem = (PlantDnaItem)((Object)geneData);
            geneData = dnaItem.getGeneData();
            JSGeneData newData = ((JSGeneData)geneData).copy();
            newData.setGeneType(GeneType.PLANT);
            newData.setBaseQuality(this.random.nextInt(20, 40));
            JSGeneUtil.writeToStack(this.resultItem, newData);
            return;
        }
    }

    private boolean isValidItem(ItemStack stack) {
        Object era;
        Item item = stack.m_41720_();
        if (item instanceof FossilItem) {
            FossilItem fossilItem = (FossilItem)item;
            if (stack.m_41720_() instanceof AnimalRemains) {
                return true;
            }
            era = fossilItem.getEra();
            if (JSAnimals.hasEra((Era)((Object)era))) {
                ResultType type = fossilItem.getResult().getResultType();
                return resultPossibilityHashMap.containsKey((Object)type);
            }
        }
        if ((era = stack.m_41720_()) instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)era;
            CompoundTag tag = stack.m_41784_();
            boolean hasNone = tag.m_128461_("entity_name").isEmpty();
            return !hasNone;
        }
        return false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInv, @NotNull Player player) {
        return new GeneticAnalyzerMachineMenu(id, playerInv, this, this.data);
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof GeneticAnalyzerMachineEntity) {
            GeneticAnalyzerMachineEntity geneticAnalyzer = (GeneticAnalyzerMachineEntity)be;
            geneticAnalyzer.localTick(level);
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return IntStream.range(9, 18).toArray();
        }
        return IntStream.range(0, 9).toArray();
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return dir != Direction.DOWN && slot < 9;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return dir == Direction.DOWN && slot >= 9;
    }

    public ItemStack m_7407_(int slot, int count) {
        return ContainerHelper.m_18969_((List)this.items, (int)slot, (int)count);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = (ItemStack)this.items.get(slot);
        this.items.set(slot, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
    }

    public boolean m_6542_(Player player) {
        return !this.m_58901_() && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public static HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> getResultPossibilityHashMap() {
        return resultPossibilityHashMap;
    }

    private static class AnalyzerResult {
        private final AnalyzerChanceItem[] chanceItems;

        public AnalyzerResult(AnalyzerChanceItem ... chanceItems) {
            this.chanceItems = chanceItems;
        }

        public AnalyzerChanceItem[] getChanceItems() {
            return this.chanceItems;
        }
    }

    private record AnalyzerChanceItem(Item item, int chance) {
    }
}

