/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.base.item.obj.egg.FertileEggItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.IncubatorMachineMenu;
import mod.azure.azurelib.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehaviors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncubatorMachineEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private final Dispatcher animDispatcher;
    private final int maxProgress = 60000;
    private int progress1 = 0;
    private int progress2 = 0;
    private int progress3 = 0;
    private int progress4 = 0;
    private int progress5 = 0;
    private boolean closed = false;
    private int nextIdleAnim = Dispatcher.IDLE_ANIM_CD;

    public IncubatorMachineEntity(BlockPos pos, BlockState state) {
        super(5, (Block)JSV1Blocks.INCUBATOR.get(), (BlockEntityType)JSV1BlockEntities.INCUBATOR.get(), pos, state);
        this.animDispatcher = new Dispatcher(this);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 1 -> IncubatorMachineEntity.this.progress1;
                    case 2 -> IncubatorMachineEntity.this.progress2;
                    case 3 -> IncubatorMachineEntity.this.progress3;
                    case 4 -> IncubatorMachineEntity.this.progress4;
                    case 5 -> IncubatorMachineEntity.this.progress5;
                    default -> 60000;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 1: {
                        IncubatorMachineEntity.this.progress1 = value;
                        break;
                    }
                    case 2: {
                        IncubatorMachineEntity.this.progress2 = value;
                        break;
                    }
                    case 3: {
                        IncubatorMachineEntity.this.progress3 = value;
                        break;
                    }
                    case 4: {
                        IncubatorMachineEntity.this.progress4 = value;
                        break;
                    }
                    case 5: {
                        IncubatorMachineEntity.this.progress5 = value;
                    }
                }
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    private void tickItem(int slot, Level lvl, IncubatorMachineEntity be) {
        ItemStack slot1 = (ItemStack)be.items.get(slot);
        if (lvl.f_46443_) {
            return;
        }
        Item item = slot1.m_41720_();
        if (item instanceof FertileEggItem) {
            FertileEggItem eggItem = (FertileEggItem)item;
            int speed = this.f_58857_.m_46469_().m_46215_(JSCommon.MACHINE_SPEED);
            int progressCur = switch (slot) {
                case 0 -> be.progress1;
                case 1 -> be.progress2;
                case 2 -> be.progress3;
                case 3 -> be.progress4;
                case 4 -> be.progress5;
                default -> 0;
            };
            JSGeneData geneData = JSGeneUtil.readFromStack(slot1);
            ResourceLocation name = ResourceLocation.m_135822_((String)geneData.getDataOwnerName(), (char)':');
            JSAnimal<?> animal1 = JSAnimals.getAnimal(name.m_135815_());
            if (animal1 == null || animal1.getItems().getHatched_egg() == null) {
                return;
            }
            if ((progressCur += speed) >= be.maxProgress) {
                JSGeneData data = JSGeneUtil.readFromStack(slot1);
                ItemStack output = ((Item)animal1.getItems().getHatched_egg().get()).m_7968_();
                int failChance = 0;
                int roll = this.f_58857_.m_213780_().m_216339_(0, 100);
                if (roll < failChance) {
                    be.items.set(slot, (Object)((Item)JSV1Items.FAILED_EGG.get()).m_7968_());
                } else {
                    if (data.isValid()) {
                        JSGeneUtil.writeToStack(output, data);
                    }
                    be.items.set(slot, (Object)output);
                }
                progressCur = 0;
            }
            switch (slot) {
                case 0: {
                    be.progress1 = progressCur;
                    break;
                }
                case 1: {
                    be.progress2 = progressCur;
                    break;
                }
                case 2: {
                    be.progress3 = progressCur;
                    break;
                }
                case 3: {
                    be.progress4 = progressCur;
                    break;
                }
                case 4: {
                    be.progress5 = progressCur;
                }
            }
        } else {
            switch (slot) {
                case 0: {
                    be.progress1 = 0;
                    break;
                }
                case 1: {
                    be.progress2 = 0;
                    break;
                }
                case 2: {
                    be.progress3 = 0;
                    break;
                }
                case 3: {
                    be.progress4 = 0;
                    break;
                }
                case 4: {
                    be.progress5 = 0;
                }
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, @NotNull Inventory p_39955_, @NotNull Player p_39956_) {
        return new IncubatorMachineMenu(p_39954_, p_39955_, this, this.data);
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (!(be instanceof IncubatorMachineEntity)) {
            return;
        }
        IncubatorMachineEntity e = (IncubatorMachineEntity)be;
        this.localTick(level, e);
    }

    public void localTick(Level lvl, IncubatorMachineEntity be) {
        be.tickItem(0, lvl, be);
        be.tickItem(1, lvl, be);
        be.tickItem(2, lvl, be);
        be.tickItem(3, lvl, be);
        be.tickItem(4, lvl, be);
        be.m_6596_();
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("js.egg.0", this.progress1);
        tag.m_128405_("js.egg.1", this.progress2);
        tag.m_128405_("js.egg.2", this.progress3);
        tag.m_128405_("js.egg.3", this.progress4);
        tag.m_128405_("js.egg.4", this.progress5);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress1 = tag.m_128451_("js.egg.0");
        this.progress2 = tag.m_128451_("js.egg.1");
        this.progress3 = tag.m_128451_("js.egg.2");
        this.progress4 = tag.m_128451_("js.egg.3");
        this.progress5 = tag.m_128451_("js.egg.4");
        this.closed = false;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("js.egg.0", this.progress1);
        tag.m_128405_("js.egg.1", this.progress2);
        tag.m_128405_("js.egg.2", this.progress3);
        tag.m_128405_("js.egg.3", this.progress4);
        tag.m_128405_("js.egg.4", this.progress5);
        return tag;
    }

    @Override
    protected void animate(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        boolean working;
        boolean bl = working = be.getContainerData().m_6413_(1) + be.getContainerData().m_6413_(2) + be.getContainerData().m_6413_(3) + be.getContainerData().m_6413_(4) + be.getContainerData().m_6413_(5) > 0;
        if (level.m_5776_() || !level.m_46749_(pos)) {
            return;
        }
        if (working) {
            if (!this.closed) {
                this.animDispatcher.closeLid(be);
                this.closed = true;
            }
        } else if (this.closed) {
            this.animDispatcher.openLid(be);
            this.closed = false;
        }
        if (this.nextIdleAnim > 0) {
            --this.nextIdleAnim;
        } else {
            int sec = level.m_213780_().m_216332_(1, 5);
            this.nextIdleAnim = (int)(JSUtils.toTickSeconds(sec) + (float)Dispatcher.IDLE_ANIM_CD);
            if (working && be.getContainerData().m_6413_(0) > 0) {
                this.animDispatcher.idle_work(be);
            } else {
                this.animDispatcher.idle(be);
            }
        }
    }

    static class Dispatcher {
        public static final int IDLE_ANIM_CD = (int)JSUtils.toTickSeconds(8.0f);
        public static final AzCommand IDLE = AzCommand.create((String)"root", (String)"animation.idle", (AzPlayBehavior)AzPlayBehaviors.PLAY_ONCE);
        public static final AzCommand IDLE_WORK = AzCommand.create((String)"root", (String)"animation.idle_work", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        public static final AzCommand OPEN = AzCommand.create((String)"root", (String)"animation.open", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        public static final AzCommand CLOSE = AzCommand.create((String)"root", (String)"animation.close", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        public static final AzCommand HOLD_CLOSED = AzCommand.create((String)"root", (String)"animation.hold_closed", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME);
        private final BlockEntity blockEntity;

        public Dispatcher(BlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        public void idle(BlockEntity BlockEntity2) {
            IDLE.sendForBlockEntity(BlockEntity2);
        }

        public void idle_work(BlockEntity BlockEntity2) {
            IDLE_WORK.sendForBlockEntity(BlockEntity2);
        }

        public void openLid(BlockEntity BlockEntity2) {
            OPEN.sendForBlockEntity(BlockEntity2);
        }

        public void closeLid(BlockEntity BlockEntity2) {
            CLOSE.sendForBlockEntity(BlockEntity2);
        }

        public void holdClosed(GenericMachineEntity BlockEntity2) {
            HOLD_CLOSED.sendForBlockEntity((BlockEntity)BlockEntity2);
        }
    }
}

