/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import java.util.ArrayList;
import java.util.List;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSMetabolismModule;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public abstract class AbstractFeederEntity
extends GenericMachineEntity {
    protected final ContainerData data;
    protected int sliderPos = 50;
    protected int openTicks = 0;
    protected boolean hasToDispense;
    protected int openTime = 0;
    protected int closeTicks = 0;
    protected int checkForFeedCooldown = 200;
    protected final ArrayList<Entity> dispensed = new ArrayList();
    protected int dispenseAmount = 0;
    protected boolean hasResult = false;

    public AbstractFeederEntity(int slots, Block block, BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(slots, block, pType, pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return AbstractFeederEntity.this.sliderPos;
            }

            public void m_8050_(int index, int value) {
                AbstractFeederEntity.this.sliderPos = value;
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    @Override
    protected void animate(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof AbstractFeederEntity) {
            AbstractFeederEntity feeder = (AbstractFeederEntity)be;
            if (this.openTicks > 0) {
                if (this.openTicks == 40) {
                    feeder.playSound(state, this.getFeederSound());
                }
                --this.openTicks;
                JSAnimations.OPEN.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.openTime > 0) {
                --this.openTime;
                JSAnimations.OPENED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.closeTicks > 0) {
                if (this.closeTicks == 39) {
                    feeder.playSound(state, this.getFeederSound());
                }
                --this.closeTicks;
                JSAnimations.CLOSE.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
            } else {
                JSAnimations.CLOSED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
            }
        }
    }

    protected SoundEvent getFeederSound() {
        return (SoundEvent)JSSounds.HATCH_DOOR.get();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("sliderPos", this.sliderPos);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setSliderPos(tag.m_128451_("sliderPos"));
        this.openTicks = tag.m_128451_("openTicks");
        this.openTime = tag.m_128451_("openTime");
        this.hasToDispense = tag.m_128471_("hasToDispense");
        this.closeTicks = tag.m_128451_("closeTicks");
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("sliderPos", this.sliderPos);
        tag.m_128405_("openTicks", this.openTicks);
        tag.m_128405_("openTime", this.openTime);
        tag.m_128379_("hasToDispense", this.hasToDispense);
        tag.m_128405_("closeTicks", this.closeTicks);
        return tag;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof AbstractFeederEntity) {
            AABB checkRadius;
            List entities;
            AbstractFeederEntity feeder = (AbstractFeederEntity)be;
            if (this.openTicks == 0 && this.openTime == 10 && this.hasToDispense) {
                for (int i = 0; i < 6; ++i) {
                    if (this.tryDispenseOne()) continue;
                    if (this.dispenseAmount <= 0) break;
                    --this.dispenseAmount;
                }
                this.dispenseAmount = 0;
                if (level.f_46443_) {
                    this.addParticle(pos);
                }
            }
            if (level.f_46443_) {
                return;
            }
            if (this.checkForFeedCooldown-- > 0) {
                return;
            }
            if (this.checkForNearby()) {
                AABB nearbyDispensed = new AABB((double)(pos.m_123341_() - 6), (double)(pos.m_123342_() - 12), (double)(pos.m_123343_() - 6), (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 12), (double)(pos.m_123343_() + 6));
                List balesNearby = level.m_6443_(this.getClassType(), nearbyDispensed, Entity::m_6084_);
                if (balesNearby.size() > 3) {
                    return;
                }
            }
            if (!(entities = level.m_6443_(JSAnimalBase.class, checkRadius = new AABB((double)(pos.m_123341_() - 64), (double)(pos.m_123342_() - 16), (double)(pos.m_123343_() - 64), (double)(pos.m_123341_() + 64), (double)(pos.m_123342_() + 64), (double)(pos.m_123343_() + 64)), base -> this.dietCheck(base.getModules().getMetabolismModule().getDiet()) && !base.isDead() && !base.m_5803_())).isEmpty()) {
                for (JSAnimalBase entity : entities) {
                    JSMetabolismModule metabolism = entity.getModules().getMetabolismModule();
                    float percentage = (float)metabolism.hungerPercentage();
                    if (!(percentage * 100.0f < (float)(feeder.getSliderPos() + 20))) continue;
                    this.dispense();
                    this.dispenseAmount = entities.size();
                    this.checkForFeedCooldown = 1600;
                    return;
                }
            }
        }
    }

    protected abstract void dispense();

    protected abstract boolean dietCheck(Diet var1);

    protected abstract <T extends Entity> Class<T> getClassType();

    protected abstract boolean checkForNearby();

    protected void addParticle(BlockPos pos) {
        if (this.hasResult) {
            Vec3 center = pos.m_252807_();
            for (int i = 0; i < 50; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 8.0f), center.m_7096_() + this.random.nextDouble() * 2.0 - 1.0, center.m_7098_() + 1.0 + this.random.nextDouble() - 1.0, center.m_7094_() + this.random.nextDouble() * 2.0 - 1.0, 4.0, 16.0, 4.0);
            }
        }
    }

    protected abstract boolean tryDispenseOne();

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237119_();
    }

    public void setSliderPos(int sliderPos) {
        this.sliderPos = sliderPos;
        this.data.m_8050_(0, sliderPos);
        this.m_6596_();
    }

    public ContainerData getData() {
        return this.data;
    }

    public int getSliderPos() {
        return this.sliderPos;
    }

    public int getOpenTicks() {
        return this.openTicks;
    }

    public boolean isHasToDispense() {
        return this.hasToDispense;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public int getCloseTicks() {
        return this.closeTicks;
    }

    public int getCheckForFeedCooldown() {
        return this.checkForFeedCooldown;
    }

    public ArrayList<Entity> getDispensed() {
        return this.dispensed;
    }

    public int getDispenseAmount() {
        return this.dispenseAmount;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public void setOpenTicks(int openTicks) {
        this.openTicks = openTicks;
    }

    public void setHasToDispense(boolean hasToDispense) {
        this.hasToDispense = hasToDispense;
    }

    public void setOpenTime(int openTime) {
        this.openTime = openTime;
    }

    public void setCloseTicks(int closeTicks) {
        this.closeTicks = closeTicks;
    }

    public void setCheckForFeedCooldown(int checkForFeedCooldown) {
        this.checkForFeedCooldown = checkForFeedCooldown;
    }

    public void setDispenseAmount(int dispenseAmount) {
        this.dispenseAmount = dispenseAmount;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }
}

