/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import java.util.List;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.AbstractFeederEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.feeder.AquaticFeederMenu;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AquaticFeederEntity
extends AbstractFeederEntity {
    public AquaticFeederEntity(BlockPos pos, BlockState blockState) {
        super(19, (Block)JSV1Blocks.AQUATIC_FEEDER.get(), (BlockEntityType)JSV1BlockEntities.AQUATIC_FEEDER.get(), pos, blockState);
    }

    @Override
    protected void addParticle(BlockPos pos) {
    }

    @Override
    protected boolean tryDispenseOne() {
        int slot = -1;
        ItemStack stack = null;
        EntityType type = null;
        for (int i = 0; i < 5; ++i) {
            ItemStack itemSlot = (ItemStack)this.getItems().get(i);
            if (!itemSlot.m_204117_(ItemTags.f_13156_) && !itemSlot.m_204117_(JSItemTags.CARNIVORE_EDIBLE) && !itemSlot.m_204117_(JSItemTags.PISCIVORE_EDIBLE) || itemSlot.m_41613_() <= 1) continue;
            slot = i;
            stack = itemSlot;
            if (stack.m_150930_(Items.f_42526_) || stack.m_150930_(Items.f_42530_)) {
                type = EntityType.f_20556_;
                break;
            }
            if (stack.m_150930_(Items.f_42527_) || stack.m_150930_(Items.f_42531_)) {
                type = EntityType.f_20519_;
                break;
            }
            if (stack.m_150930_(Items.f_42528_)) {
                type = EntityType.f_20489_;
                break;
            }
            if (stack.m_150930_((Item)JSV1Animals.BONITO.getItems().getRawMeat().get())) {
                type = (EntityType)JSV1Animals.BONITO.getEntityType().get();
                break;
            }
            if (!stack.m_150930_((Item)JSV1Items.SQUID.get()) && !stack.m_150930_((Item)JSV1Items.SQUID_COOKED.get())) break;
            type = EntityType.f_20480_;
            break;
        }
        if (slot == -1) {
            return false;
        }
        this.hasResult = true;
        if (type == null) {
            return false;
        }
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_45976_(type.m_142225_(), new AABB(this.m_58899_()).m_82400_(8.0)).size() > 5) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            return true;
        }
        if (this.f_58857_.m_46469_().m_46207_(JSCommon.FEEDER_DISPENSE_DRAIN)) {
            stack.m_41774_(2);
        }
        this.getItems().set(slot, (Object)stack);
        LivingEntity entity = (LivingEntity)type.m_20615_(this.f_58857_);
        if (entity == null) {
            return false;
        }
        if (entity instanceof TropicalFish) {
            TropicalFish.Variant tropicalfish$variant;
            TropicalFish fish = (TropicalFish)entity;
            RandomSource randomsource = this.f_58857_.m_213780_();
            if ((double)randomsource.m_188501_() < 0.9) {
                tropicalfish$variant = (TropicalFish.Variant)Util.m_214621_((List)TropicalFish.f_30007_, (RandomSource)randomsource);
            } else {
                Object[] atropicalfish$pattern = TropicalFish.Pattern.values();
                Object[] adyecolor = DyeColor.values();
                TropicalFish.Pattern tropicalfish$pattern = (TropicalFish.Pattern)Util.m_214670_((Object[])atropicalfish$pattern, (RandomSource)randomsource);
                DyeColor dyecolor = (DyeColor)Util.m_214670_((Object[])adyecolor, (RandomSource)randomsource);
                DyeColor dyecolor1 = (DyeColor)Util.m_214670_((Object[])adyecolor, (RandomSource)randomsource);
                tropicalfish$variant = new TropicalFish.Variant(tropicalfish$pattern, dyecolor, dyecolor1);
            }
            fish.m_28464_(tropicalfish$variant.f_262204_());
        }
        Vec3 pos = this.m_58899_().m_252807_().m_82520_(0.0, -0.5, 0.0);
        entity.m_146884_(pos);
        float rot = switch ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)) {
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        entity.m_146922_(rot);
        entity.m_5618_(rot);
        entity.m_5616_(rot);
        float radians = (float)Math.toRadians(entity.m_146908_());
        double x = -Math.sin(radians);
        double z = Math.cos(radians);
        double speed = 0.5;
        entity.m_20334_(x * speed, 0.0, z * speed);
        this.f_58857_.m_7967_((Entity)entity);
        this.dispensed.add(entity);
        this.checkForFeedCooldown = 2000;
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new AquaticFeederMenu(containerId, playerInventory, this, null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void dispense() {
        BlockState thisState = this.f_58857_.m_8055_(this.m_58899_());
        if (thisState.m_60819_().m_76178_()) {
            this.playSound(this.m_58900_(), SoundEvents.f_11748_);
            this.hasResult = false;
            this.openTicks = 0;
            this.openTime = 0;
            this.closeTicks = 0;
            this.hasToDispense = false;
            return;
        }
        if (this.openTicks > 0 || this.openTime > 0 || this.closeTicks > 0) {
            return;
        }
        this.openTicks = 40;
        this.openTime = 40;
        this.closeTicks = 40;
        this.hasToDispense = true;
        this.m_6596_();
    }

    @Override
    protected boolean dietCheck(Diet base) {
        return base.is(AnimalDietType.PISCIVORE) || base.is(AnimalDietType.CARNIVORE);
    }

    @Override
    protected <T extends Entity> Class<T> getClassType() {
        return null;
    }

    @Override
    protected boolean checkForNearby() {
        return false;
    }
}

