/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.AbstractFeederEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.feeder.CarnivoreFeederMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CarnivoreFeederEntity
extends AbstractFeederEntity {
    private boolean dispenseHigher = false;

    public CarnivoreFeederEntity(BlockPos pos, BlockState blockState) {
        super(19, (Block)JSV1Blocks.CARNIVORE_FEEDER.get(), (BlockEntityType)JSV1BlockEntities.CARNIVORE_FEEDER.get(), pos, blockState);
    }

    @Override
    protected boolean tryDispenseOne() {
        Vec3 pos;
        MeatEntity entity;
        int slot = -1;
        ItemStack stack = null;
        EntityType type = null;
        boolean isMosquito = false;
        for (int i = 0; i < 5; ++i) {
            ItemStack itemSlot = (ItemStack)this.getItems().get(i);
            if (itemSlot.m_204117_(JSItemTags.CARNIVORE_EDIBLE)) {
                slot = i;
                stack = itemSlot;
                if (stack.m_41613_() <= 4) continue;
                if (stack.m_150930_(Items.f_42579_)) {
                    type = EntityType.f_20557_;
                    break;
                }
                if (stack.m_150930_(Items.f_42581_)) {
                    type = EntityType.f_20555_;
                    break;
                }
                if (!stack.m_150930_(Items.f_42485_)) break;
                type = EntityType.f_20510_;
                break;
            }
            if (!itemSlot.m_150930_((Item)JSV1Items.MOSQUITO.get())) continue;
            slot = i;
            stack = itemSlot;
            if (stack.m_41613_() <= 1) continue;
            type = (EntityType)JSV1Animals.MOSQUITO.getEntityType().get();
            isMosquito = true;
            break;
        }
        if (slot == -1) {
            return false;
        }
        assert (this.f_58857_ != null);
        this.hasResult = true;
        if (this.f_58857_.f_46443_) {
            return true;
        }
        if (type == null) {
            if (this.f_58857_.m_46469_().m_46207_(JSCommon.FEEDER_DISPENSE_DRAIN)) {
                stack.m_41774_(2);
            }
            this.getItems().set(slot, (Object)stack);
            entity = (MeatEntity)((EntityType)JSEntities.MEAT.get()).m_20615_(this.f_58857_);
            if (entity == null) {
                return false;
            }
            pos = this.m_58899_().m_252807_().m_82520_((double)(this.random.nextFloat() * 2.0f - 1.0f), 0.0, (double)(this.random.nextFloat() * 2.0f - 1.0f));
            if (this.dispenseHigher) {
                pos = pos.m_82520_(0.0, 1.2, 0.0);
            }
        } else {
            if (this.f_58857_.m_45976_(type.m_142225_(), new AABB(this.m_58899_()).m_82400_(8.0)).size() > 5) {
                return false;
            }
            if (this.f_58857_.m_46469_().m_46207_(JSCommon.FEEDER_DISPENSE_DRAIN)) {
                stack.m_41774_(isMosquito ? 1 : 5);
            }
            this.getItems().set(slot, (Object)stack);
            LivingEntity entity2 = (LivingEntity)type.m_20615_(this.f_58857_);
            if (entity2 == null) {
                return false;
            }
            pos = this.m_58899_().m_252807_().m_82520_(0.0, isMosquito ? 0.0 : -0.5, 0.0);
            if (this.dispenseHigher) {
                pos = pos.m_82520_(isMosquito ? (double)(this.random.nextFloat() - 0.5f) : 0.0, 1.2 + (double)(isMosquito ? 0.5f : 0.0f), isMosquito ? (double)(this.random.nextFloat() - 0.5f) : 0.0);
            }
            entity2.m_146884_(pos);
            if (entity2 instanceof JSAnimalBase) {
                JSAnimalBase base = (JSAnimalBase)entity2;
                base.getModules().getGeneticModule().setMale(this.random.nextBoolean());
                base.getModules().getGrowthStageModule().setMax();
                base.getModules().getMetabolismModule().setMax();
            }
            this.f_58857_.m_7967_((Entity)entity2);
            this.checkForFeedCooldown = 2000;
            this.dispensed.add(entity2);
            return isMosquito;
        }
        entity.m_146884_(pos);
        entity.m_146922_(this.random.nextInt(0, 360) - 180);
        this.dispensed.add(entity);
        this.f_58857_.m_7967_((Entity)entity);
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new CarnivoreFeederMenu(containerId, playerInventory, this, null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void dispense() {
        BlockPos posAbove = this.m_58899_().m_7494_();
        BlockState state = this.f_58857_.m_8055_(posAbove);
        if (state.m_60838_((BlockGetter)this.f_58857_, posAbove)) {
            this.playSound(this.m_58900_(), SoundEvents.f_11748_);
            this.hasResult = false;
            this.openTicks = 0;
            this.openTime = 0;
            this.closeTicks = 0;
            this.hasToDispense = false;
            return;
        }
        boolean bl = this.dispenseHigher = !state.m_60795_();
        if (this.openTicks > 0 || this.openTime > 0 || this.closeTicks > 0) {
            return;
        }
        this.openTicks = 40;
        this.openTime = 40;
        this.closeTicks = 40;
        this.hasToDispense = true;
        this.m_6596_();
    }

    @Override
    protected boolean dietCheck(Diet diet) {
        return diet.is(AnimalDietType.CARNIVORE) || diet.is(AnimalDietType.PISCIVORE) || diet.is(AnimalDietType.OMNIVORE);
    }

    protected Class<MeatEntity> getClassType() {
        return MeatEntity.class;
    }

    @Override
    protected boolean checkForNearby() {
        return true;
    }
}

