/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.AbstractFeederEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.feeder.HerbivoreFeederMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HerbivoreFeederEntity
extends AbstractFeederEntity {
    private boolean dispenseHigher = false;

    public HerbivoreFeederEntity(BlockPos pos, BlockState blockState) {
        super(19, (Block)JSV1Blocks.HERBIVORE_FEEDER.get(), (BlockEntityType)JSV1BlockEntities.HERBIVORE_FEEDER.get(), pos, blockState);
    }

    @Override
    protected boolean tryDispenseOne() {
        int slot = -1;
        ItemStack stack = null;
        for (int i = 0; i < 5; ++i) {
            ItemStack itemSlot = (ItemStack)this.getItems().get(i);
            if (!itemSlot.m_204117_(ItemTags.f_13143_) && !itemSlot.m_204117_(JSItemTags.HERBIVORE_EDIBLE) || itemSlot.m_41613_() <= 1) continue;
            slot = i;
            stack = itemSlot;
            break;
        }
        if (slot == -1) {
            return false;
        }
        this.hasResult = true;
        if (this.f_58857_.f_46443_) {
            return true;
        }
        if (this.f_58857_.m_46469_().m_46207_(JSCommon.FEEDER_DISPENSE_DRAIN)) {
            stack.m_41774_(2);
        }
        this.getItems().set(slot, (Object)stack);
        HaybaleEntity entity = (HaybaleEntity)((EntityType)JSEntities.HAYBALE.get()).m_20615_(this.f_58857_);
        if (entity == null) {
            return false;
        }
        entity.m_20256_(new Vec3(this.random.nextBoolean() ? -0.2 : 0.2 + (double)((this.random.nextFloat() - 0.5f) / 3.0f), 0.6 + (double)(this.random.nextFloat() / 2.0f), this.random.nextBoolean() ? -0.2 : 0.2 + (double)((this.random.nextFloat() - 0.5f) / 3.0f)));
        entity.m_146884_(this.m_58899_().m_252807_().m_82520_(0.0, 0.5, 0.0));
        this.f_58857_.m_7967_((Entity)entity);
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new HerbivoreFeederMenu(containerId, playerInventory, this, null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void dispense() {
        BlockPos posAbove = this.m_58899_().m_7494_();
        BlockState state = this.f_58857_.m_8055_(posAbove);
        if (state.m_60838_((BlockGetter)this.f_58857_, posAbove)) {
            this.playSound(this.m_58900_(), SoundEvents.f_11748_);
            this.hasResult = false;
            this.openTicks = 0;
            this.openTime = 0;
            this.closeTicks = 0;
            this.hasToDispense = false;
            return;
        }
        boolean bl = this.dispenseHigher = !state.m_60795_();
        if (this.openTicks > 0 || this.openTime > 0 || this.closeTicks > 0) {
            return;
        }
        this.openTicks = 40;
        this.openTime = 40;
        this.closeTicks = 40;
        this.hasToDispense = true;
        this.m_6596_();
    }

    @Override
    protected boolean dietCheck(Diet base) {
        return base.is(AnimalDietType.HERBIVORE) || base.is(AnimalDietType.OMNIVORE);
    }

    protected Class<HaybaleEntity> getClassType() {
        return HaybaleEntity.class;
    }

    @Override
    protected boolean checkForNearby() {
        return true;
    }
}

