/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.menu.obj;

import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.JSSlotItemHandler;
import jp.jurassicsaga.server.v1.menu.obj.MachineContainerWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

public abstract class GenericMachineMenu
extends AbstractContainerMenu {
    private final Level level;
    private final ContainerData data;
    public GenericMachineEntity blockEntity;
    protected int invXOffset = 8;
    protected int invYOffset = 84;
    protected int hotBarY = 142;

    public GenericMachineMenu(MenuType<?> menuType, int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(menuType, pContainerId, inv, (GenericMachineEntity)inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public GenericMachineMenu(MenuType<?> menuType, int pContainerId, Inventory inv, GenericMachineEntity blockEntity, ContainerData data) {
        super(menuType, pContainerId);
        GenericMachineMenu.m_38869_((Container)inv, (int)13);
        this.initOffset();
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.blockEntity = blockEntity;
        this.addSlots(new MachineContainerWrapper(blockEntity));
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        if (data != null) {
            this.m_38884_(data);
        }
    }

    protected void initOffset() {
    }

    protected abstract void addSlots(SimpleContainer var1);

    private void addPlayerInventory(Inventory playerInventory) {
        this.invYOffset += 10;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, this.invXOffset + l * 18 + this.getInvExtraXOffset(), this.invYOffset + i * 18 + this.getInvExtraYOffset()));
            }
        }
    }

    public int getInvExtraXOffset() {
        return 0;
    }

    protected void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, this.invXOffset + i * 18 + this.getHotbarExtraXOffset(), this.hotBarY + this.getHotbarExtraYOffset()));
        }
    }

    public int getHotbarExtraXOffset() {
        return 0;
    }

    public boolean m_6875_(Player pPlayer) {
        return GenericMachineMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)this.blockEntity.getBlock());
    }

    public int getInvExtraYOffset() {
        return 0;
    }

    public int getHotbarExtraYOffset() {
        return 0;
    }

    public Vector2d getPlayerInventoryLabelOffset() {
        return new Vector2d(0.0, 0.0);
    }

    public Vector2d getLabelOffset() {
        return new Vector2d(0.0, 0.0);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        int slotcount = this.f_38839_.size() - 36;
        if (slotcount <= 0) {
            return ItemStack.f_41583_;
        }
        int endIndex = 36 + slotcount;
        if (pIndex >= slotcount && pIndex <= this.f_38839_.size()) {
            if (!this.m_38903_(sourceStack, 0, slotcount, false) && (pIndex < endIndex - 9 ? !this.m_38903_(sourceStack, endIndex - 9, endIndex, false) : !this.m_38903_(sourceStack, slotcount, endIndex - 9, false))) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < slotcount) {
            if (!this.m_38903_(sourceStack, slotcount, endIndex, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        if (sourceSlot instanceof JSSlotItemHandler) {
            JSSlotItemHandler slotItemHandler = (JSSlotItemHandler)sourceSlot;
            slotItemHandler.onTake(pPlayer, sourceStack, copyOfSourceStack);
        } else {
            sourceSlot.m_142406_(pPlayer, sourceStack);
        }
        return copyOfSourceStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!slot.m_5857_(stack)) {
                    flag = false;
                } else if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (k = slot.m_5866_(itemstack))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < k) {
                        stack.m_41774_(k - itemstack.m_41613_());
                        itemstack.m_41764_(k);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(stack)) {
                    int l = slot1.m_5866_(stack);
                    slot1.m_269060_(stack.m_41620_(Math.min(stack.m_41613_(), l)));
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ContainerData getData() {
        return this.data;
    }
}

