/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.feature;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.world.feature.JSFeatures;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.world.feature.features.JSSimpleBlockFeature;
import jp.jurassicsaga.server.v1.world.tree.placer.AraucarioxylonTrunkGrower;
import jp.jurassicsaga.server.v1.world.tree.placer.GordonopterisTrunkGrower;
import jp.jurassicsaga.server.v1.world.tree.placer.LepidodendronTrunkGrower;
import jp.jurassicsaga.server.v1.world.tree.placer.SpinifructusTrunkGrower;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class JSV1ConfiguredFeatures {
    public static final HashMap<Era, Pair<ResourceKey<ConfiguredFeature<?, ?>>, ResourceKey<ConfiguredFeature<?, ?>>>> ERA_KEYS = new HashMap();
    public static final ResourceKey<ConfiguredFeature<?, ?>> EMPTY = JSV1ConfiguredFeatures.registerKey("empty");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HELICONIA = JSV1ConfiguredFeatures.registerKey("heliconia");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROYAL_FERN = JSV1ConfiguredFeatures.registerKey("royal_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEST_INDIAN_LILAC = JSV1ConfiguredFeatures.registerKey("west_indian_lilac");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWISS_CHEESE_PLANT = JSV1ConfiguredFeatures.registerKey("swiss_cheese_plant");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARAUCARIOXYLON = JSV1ConfiguredFeatures.registerKey("araucarioxylon_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GORDONOPTERIS = JSV1ConfiguredFeatures.registerKey("gordonopteris_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEPIDODENDRON = JSV1ConfiguredFeatures.registerKey("lepidodendron_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPINIFRUCTUS = JSV1ConfiguredFeatures.registerKey("spinifructus_tree");
    private static BootstapContext<ConfiguredFeature<?, ?>> currentContext;

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        currentContext = context;
        TagMatchTest deepslateRuletest = new TagMatchTest(BlockTags.f_144267_);
        TagMatchTest stoneRuletest = new TagMatchTest(BlockTags.f_144266_);
        JSV1ConfiguredFeatures.registerSimplePlant(HELICONIA, 16, 10, 7, (Block)JSV1Blocks.HELICONIA.get());
        JSV1ConfiguredFeatures.registerSimplePlant(ROYAL_FERN, 16, 10, 7, (Block)JSV1Blocks.ROYAL_FERN.get());
        JSV1ConfiguredFeatures.registerSimplePlant(WEST_INDIAN_LILAC, 16, 10, 7, (Block)JSV1Blocks.WEST_INDIAN_LILAC.get());
        JSV1ConfiguredFeatures.registerSimplePlant(SWISS_CHEESE_PLANT, 16, 10, 7, (Block)JSV1Blocks.SWISS_CHEESE_PLANT.get());
        for (Era value : Era.values()) {
            ResourceKey<ConfiguredFeature<?, ?>> FOSSIL_ORE = null;
            ResourceKey<ConfiguredFeature<?, ?>> MARINE_ORE = null;
            if (value.isHasFossilOre()) {
                FOSSIL_ORE = JSV1ConfiguredFeatures.registerKey(value.getEraName() + "_fossil_placed");
                List<OreConfiguration.TargetBlockState> FOSSIL_ORES = List.of(OreConfiguration.m_161021_((RuleTest)stoneRuletest, (BlockState)((Block)value.getFossilOre().get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateRuletest, (BlockState)((Block)value.getFossilOre().get()).m_49966_()));
                JSV1ConfiguredFeatures.register(FOSSIL_ORE, Feature.f_65731_, new OreConfiguration(FOSSIL_ORES, value.getGenerationSettings().size(), 0.0f));
            }
            if (value.isHasMarineOre()) {
                MARINE_ORE = JSV1ConfiguredFeatures.registerKey(value.getEraName() + "_marine_placed");
                List<OreConfiguration.TargetBlockState> ORES = List.of(OreConfiguration.m_161021_((RuleTest)stoneRuletest, (BlockState)((Block)value.getMarineOre().get()).m_49966_()));
                JSV1ConfiguredFeatures.register(MARINE_ORE, Feature.f_65731_, new OreConfiguration(ORES, value.getGenerationSettings().size(), 0.0f));
            }
            ERA_KEYS.put(value, Pair.of(FOSSIL_ORE == null ? EMPTY : FOSSIL_ORE, MARINE_ORE == null ? EMPTY : MARINE_ORE));
        }
        JSV1ConfiguredFeatures.register(ARAUCARIOXYLON, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get())), (TrunkPlacer)new AraucarioxylonTrunkGrower(14, 1, 14), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68251_());
        JSV1ConfiguredFeatures.register(GORDONOPTERIS, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.GORDONPTERIS.LOG.get())), (TrunkPlacer)new GordonopterisTrunkGrower(2, 1, 2), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.GORDONPTERIS.LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68251_());
        JSV1ConfiguredFeatures.register(LEPIDODENDRON, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.LEPIDODENDRON.LOG.get())), (TrunkPlacer)new LepidodendronTrunkGrower(25, 5, 10), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.LEPIDODENDRON.LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68251_());
        JSV1ConfiguredFeatures.register(SPINIFRUCTUS, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.SPINIFRUCTUS.LOG.get())), (TrunkPlacer)new SpinifructusTrunkGrower(5, 3, 5), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)JSV1Blocks.SPINIFRUCTUS.LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68251_());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("jurassicsaga", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        currentContext.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static void registerSimplePlant(ResourceKey<ConfiguredFeature<?, ?>> featureResourceKey, int tries, int xzSpread, int ySpread, Block block) {
        JSSimpleBlockFeature feature = (JSSimpleBlockFeature)((Object)JSFeatures.SIMPLE_BLOCK.get());
        JSV1ConfiguredFeatures.register(featureResourceKey, Feature.f_65763_, new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.f_190393_}))));
    }
}

