/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class AraucarioxylonTrunkGrower
extends TrunkPlacer {
    public static final Codec<AraucarioxylonTrunkGrower> CODEC = RecordCodecBuilder.create(p_70136_ -> AraucarioxylonTrunkGrower.m_70305_((RecordCodecBuilder.Instance)p_70136_).apply((Applicative)p_70136_, AraucarioxylonTrunkGrower::new));

    public AraucarioxylonTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)JSV1TrunkPlacerTypes.ARAUCARIOXYLON.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        BlockPos trunkPos;
        int i;
        AraucarioxylonTrunkGrower.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        int trunkHeight = 30 + random.m_188503_(20);
        int branchLength = (trunkHeight - 2) / 8;
        int step = 15;
        for (i = 0; i < trunkHeight; ++i) {
            trunkPos = pos.m_6630_(i);
            this.m_226187_(level, blockSetter, random, trunkPos, config);
            if (i > 2 && i < trunkHeight - 2) {
                if (--step <= 0) {
                    step = 10;
                    branchLength = Math.max(1, branchLength - 1);
                }
                if (step == 5 || step == 10) {
                    this.placeBranches(level, blockSetter, trunkPos, branchLength);
                }
            }
            if (i != trunkHeight - 1) continue;
            this.placeLeavesAround(level, blockSetter, random, trunkPos, config);
            blockSetter.accept(trunkPos.m_6630_(2), ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).m_49966_());
        }
        step = 15;
        branchLength = (trunkHeight - 2) / 8;
        for (i = 0; i < trunkHeight; ++i) {
            if (i <= 2 || i >= trunkHeight - 2) continue;
            if (--step <= 0) {
                step = 10;
                branchLength = Math.max(1, branchLength - 1);
            }
            if (step != 5 && step != 10) continue;
            trunkPos = pos.m_6630_(i);
            this.placeBranchLeaves(level, blockSetter, random, trunkPos, config, branchLength);
        }
        return ImmutableList.of();
    }

    private void placeBranches(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos base, int length) {
        BlockState log = ((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get()).m_49966_();
        for (int j = 0; j < length; ++j) {
            blockSetter.accept(base.m_6625_(j).m_122013_(j), log);
            blockSetter.accept(base.m_6625_(j).m_122030_(j), log);
            blockSetter.accept(base.m_6625_(j).m_122020_(j), log);
            blockSetter.accept(base.m_6625_(j).m_122025_(j), log);
        }
    }

    private void placeBranchLeaves(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos base, TreeConfiguration config, int length) {
        for (int j = 0; j < length; ++j) {
            this.placeLeavesAround(level, blockSetter, random, base.m_6625_(j).m_122013_(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.m_6625_(j).m_122030_(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.m_6625_(j).m_122020_(j), config);
            this.placeLeavesAround(level, blockSetter, random, base.m_6625_(j).m_122025_(j), config);
        }
    }

    private void placeLeavesAround(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        for (BlockPos offset : new BlockPos[]{pos.m_7494_(), pos.m_7495_(), pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_()}) {
            if (!this.isValid(level, offset)) continue;
            blockSetter.accept(offset, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).m_49966_());
        }
    }

    private boolean isValid(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

