/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class GordonopterisTrunkGrower
extends TrunkPlacer {
    public static final Codec<GordonopterisTrunkGrower> CODEC = RecordCodecBuilder.create(p_70136_ -> GordonopterisTrunkGrower.m_70305_((RecordCodecBuilder.Instance)p_70136_).apply((Applicative)p_70136_, GordonopterisTrunkGrower::new));

    public GordonopterisTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)JSV1TrunkPlacerTypes.GORDONOPTERIS.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        GordonopterisTrunkGrower.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        int height = this.f_70263_ + random.m_188503_(this.f_70264_ + 1) + random.m_188503_(this.f_70265_ + 1);
        if (height < 2) {
            height = 2;
        }
        if (height > 4) {
            height = 4;
        }
        BlockPos topPos = pos;
        for (int i = 0; i < height; ++i) {
            topPos = pos.m_6630_(i);
            blockSetter.accept(topPos, config.f_68185_.m_213972_(random, pos));
        }
        this.placeCrown(level, blockSetter, random, topPos, config);
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(topPos, 0, false));
    }

    private void placeCrown(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        BlockState leaves = config.f_161213_.m_213972_(random, pos);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                this.tryPlaceLeaf(level, blockSetter, pos.m_7918_(dx, 0, dz), leaves);
            }
        }
        this.tryPlaceLeaf(level, blockSetter, pos.m_122013_(2).m_6630_(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.m_122020_(2).m_6630_(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.m_122030_(2).m_6630_(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.m_122025_(2).m_6630_(1), leaves);
        this.tryPlaceLeaf(level, blockSetter, pos.m_7494_(), leaves);
    }

    private void tryPlaceLeaf(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state) {
        if (this.isValid(level, pos)) {
            blockSetter.accept(pos, state);
        }
    }

    public boolean isValid(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

