/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class LepidodendronTrunkGrower
extends TrunkPlacer {
    public static final Codec<LepidodendronTrunkGrower> CODEC = RecordCodecBuilder.create(p_70136_ -> LepidodendronTrunkGrower.m_70305_((RecordCodecBuilder.Instance)p_70136_).apply((Applicative)p_70136_, LepidodendronTrunkGrower::new));

    public LepidodendronTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)JSV1TrunkPlacerTypes.LEPIDODENDRON.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        LepidodendronTrunkGrower.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        int height = this.f_70263_ + random.m_188503_(this.f_70264_ + 1) + random.m_188503_(this.f_70265_ + 1);
        if (height < 30) {
            height = 30;
        }
        if (height > 40) {
            height = 40;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                columns.add(new Column(dx, dz, height));
            }
        }
        for (Column c : columns) {
            double dist = Math.sqrt(c.dx * c.dx + c.dz * c.dz);
            if (dist > 1.0) {
                c.maxY = random.m_188503_(3);
                continue;
            }
            if (dist > 0.1) {
                c.maxY = 3 + random.m_188503_(3);
                continue;
            }
            c.maxY = height;
        }
        BlockPos topPos = pos;
        for (int y = 0; y < height; ++y) {
            for (Column c : columns) {
                if (y != 0 && y > c.maxY) continue;
                BlockPos trunkPos = pos.m_7918_(c.dx, y, c.dz);
                blockSetter.accept(trunkPos, config.f_68185_.m_213972_(random, pos));
                topPos = trunkPos;
                if (y != 0 || c.maxY > 1) continue;
                int rootLength = 1 + random.m_188503_(3);
                for (int f = 1; f <= rootLength; ++f) {
                    int yOffset = 0;
                    if (f == rootLength) {
                        yOffset = (double)random.m_188501_() < 0.5 ? -1 : 0;
                    } else if ((double)random.m_188501_() < 0.3) {
                        yOffset = -1;
                    } else if ((double)random.m_188501_() < 0.3) {
                        yOffset = 1;
                    }
                    BlockPos rootPos = pos.m_7918_(c.dx * (f + 1), yOffset, c.dz * (f + 1));
                    blockSetter.accept(rootPos, config.f_68185_.m_213972_(random, pos));
                }
            }
        }
        int crownBaseY = (int)((double)height * 0.925);
        for (int i = 0; i < 7; ++i) {
            if (!(random.m_188501_() < 0.7f)) continue;
            int dx = random.m_188499_() ? 1 : -1;
            int dz = random.m_188499_() ? 1 : -1;
            int supportLength = 2 + random.m_188503_(2);
            int startY = crownBaseY + random.m_188503_(3);
            BlockPos supportPos = pos.m_6630_(startY);
            for (int s = 1; s <= supportLength; ++s) {
                BlockPos branch = supportPos.m_7918_(dx * s, s / 2, dz * s);
                blockSetter.accept(branch, config.f_68185_.m_213972_(random, pos));
            }
        }
        this.placeCrownSupports(level, blockSetter, random, pos.m_6630_(height - 2), config);
        this.placeCrown(level, blockSetter, random, topPos.m_6625_(1), config);
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(topPos.m_7494_(), 0, false));
    }

    private void placeCrownSupports(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        BlockState log = config.f_68185_.m_213972_(random, pos);
        int branchCount = 6 + random.m_188503_(3);
        for (int i = 0; i < branchCount; ++i) {
            int dx = random.m_188499_() ? 1 : -1;
            int dz = random.m_188499_() ? 1 : -1;
            int length = 2 + random.m_188503_(2);
            int baseY = random.m_188503_(3);
            BlockPos branchBase = pos.m_6630_(baseY);
            for (int s = 1; s <= length; ++s) {
                BlockPos branch = branchBase.m_7918_(dx * s, s / 3, dz * s);
                blockSetter.accept(branch, log);
                if (s != length) continue;
                BlockState leaves = config.f_161213_.m_213972_(random, branch);
                this.placeLeafLayer(level, blockSetter, branch, leaves, 2);
            }
        }
    }

    private void placeCrown(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        BlockState leaves = config.f_161213_.m_213972_(random, pos);
        this.placeLeafLayer(level, blockSetter, pos.m_7495_(), leaves, 3);
        this.placeLeafLayer(level, blockSetter, pos, leaves, 4);
        this.placeLeafLayer(level, blockSetter, pos.m_7494_(), leaves, 5);
        this.placeLeafLayer(level, blockSetter, pos.m_6630_(2), leaves, 6);
        this.placeLeafLayer(level, blockSetter, pos.m_6630_(3), leaves, 5);
        this.placeLeafLayer(level, blockSetter, pos.m_6630_(4), leaves, 4);
        this.placeLeafLayer(level, blockSetter, pos.m_6630_(5), leaves, 5);
        this.placeLeafLayer(level, blockSetter, pos.m_6630_(6), leaves, 3);
    }

    private void placeLeafLayer(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState leaves, int radius) {
        int rSq = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx * dx + dz * dz > rSq) continue;
                BlockPos leafPos = pos.m_7918_(dx, 0, dz);
                this.tryPlaceLeaf(level, blockSetter, leafPos, leaves);
            }
        }
    }

    private void tryPlaceLeaf(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, BlockPos pos, BlockState state) {
        if (this.isValid(level, pos)) {
            blockSetter.accept(pos, state);
        }
    }

    public boolean isValid(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }

    private static class Column {
        final int dx;
        final int dz;
        int maxY;

        Column(int dx, int dz, int maxY) {
            this.dx = dx;
            this.dz = dz;
            this.maxY = maxY;
        }
    }
}

