/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extant.avian;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v2.animal.animations.extant.ButterflyAnimations;
import jp.jurassicsaga.server.v2.animal.entity.extant.avian.ButterflyEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class ButterflyAnimal
extends AbstractJSAnimal<ButterflyEntity> {
    public ButterflyAnimal() {
        super("butterfly");
        this.setAnimator(new ButterflyAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<ButterflyEntity> geneticProperties) {
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<ButterflyEntity> metabolismProperties) {
        metabolismProperties.disableSleep();
        metabolismProperties.disableBreeding();
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<ButterflyEntity> miscProperties) {
        miscProperties.setGenderedVariants();
        miscProperties.setEra(Era.NONE);
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.addBiomeTarget("overworld", 2, 2, 4, MobCategory.CREATURE, (TagKey<Biome>)BiomeTags.f_215817_);
        miscProperties.setSpawnPlacementType(SpawnPlacements.Type.ON_GROUND);
        miscProperties.setSpawnHeightMap(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        miscProperties.setSpawnPredicate((SpawnPlacements.SpawnPredicate<ButterflyEntity>)((SpawnPlacements.SpawnPredicate)ButterflyEntity::canSpawn));
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<ButterflyEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(Player.class);
        socialGroupProperties.addHerdTargets(ButterflyEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(50.0f);
        socialGroupProperties.setMaxHerdSize(20);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<ButterflyEntity> itemProperties) {
        itemProperties.disableEgg();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.SPIDER);
        itemProperties.setSpawnEggColors(3489351, 10792116);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<ButterflyEntity> attributes, EntityBaseProperties<ButterflyEntity> base) {
        base.setAnimalType(AnimalType.INSECT);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setMaxTurnRate(64.0);
        base.setTurnSmoothRate((double)0.8f);
        base.setMaxHeadRotation(90.0, 30.0);
        base.setRenderScale((double)0.4f);
        base.setLocator((ResourceLocator)new ResourceLocator<ButterflyEntity>(){
            private Cache<String, ResourceLocation> cache = CacheBuilder.newBuilder().maximumSize(5000L).build();

            public ResourceLocation getModelLocation(ButterflyEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String key = "model:" + name;
                try {
                    return (ResourceLocation)this.cache.get((Object)key, () -> JSCommon.createId("geo/animal/v2.0/" + name + "/" + name + ".geo.json"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }

            public ResourceLocation getAnimationLocation(ButterflyEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String key = "anim:" + name;
                try {
                    return (ResourceLocation)this.cache.get((Object)key, () -> JSCommon.createId("animations/animal/v2.0/" + name + "/" + name + ".animation.json"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }

            public ResourceLocation getTextureLocation(ButterflyEntity entity) {
                String name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
                String variant = entity.getVariant().getName();
                String key = "tex:" + name + ";var:" + variant;
                try {
                    return (ResourceLocation)this.cache.get((Object)key, () -> JSCommon.createId("textures/geo/animal/v2.0/" + name + "/" + name + "_" + variant + ".png"));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        attributes.setSpawnFar();
        attributes.setEntityFactory(ButterflyEntity::new);
        attributes.setCategory(MobCategory.AMBIENT);
        attributes.setEyeHeight(0.5);
        attributes.setMaxHealth(0.5);
        attributes.setAttackDamage(0.0);
        attributes.setAttackSpeed(3.0);
        attributes.setDimensions(0.5, 0.5);
        attributes.setMovementSpeed((double)0.04f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setFlyingSpeed((double)0.15f);
    }
}

