/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.GenericHerdPool;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MaiasauraEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class MaiasauraAnimal
extends AbstractJSAnimal<MaiasauraEntity> {
    public MaiasauraAnimal() {
        super("maiasaura");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<MaiasauraEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.15f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(1.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<MaiasauraEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(6.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(4.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<MaiasauraEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.0f, 0.825f});
        miscProperties.setGuidebookOffset(new Vec2(-1.1f, 0.0f), new Vec2(1.0f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
        miscProperties.setGuideBookDescription("Maiasaura, a hadrosaurid genus, famous as a \"good mother lizard,\" as fossils show it cared for its young. Maiasaura also were light weight for their size and could run. ");
        miscProperties.setGuideBookSource("North America");
        miscProperties.setGuideBookScientificName("Maiasaura peeblesorum");
        miscProperties.setAdvancementTitle("Good mother lizard");
        miscProperties.setVersion(Versions.VERSION_2);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<MaiasauraEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class);
        socialGroupProperties.addHerdTargets(GenericHerdPool.BASE_HERBIVORE_POOL);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<MaiasauraEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(12357221, 6437928);
        itemProperties.setSpawnEggColorsMale(11961688, 6437928);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<MaiasauraEntity> attributes, EntityBaseProperties<MaiasauraEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(9.0);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setTurnSmoothRate((double)0.45f);
        base.setMaxTurnRate(9.0);
        base.setRenderScale(1.25);
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setPersistent();
        attributes.setEntityFactory(MaiasauraEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(85.0);
        attributes.setDimensions((double)2.15f, (double)3.2f);
        attributes.setMovementSpeed((double)0.19f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)2.2f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
        attributes.setTrackingRange(64.0);
    }
}

