/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extant.BasiliskEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import jp.jurassicsaga.server.v2.animal.animations.extinct.terrestial.ProceratosaurusAnimations;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.AchillobatorEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.CoelurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MicroceratusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.OthnielaEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.ProceratosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class ProceratosaurusAnimal
extends AbstractJSAnimal<ProceratosaurusEntity> {
    public ProceratosaurusAnimal() {
        super("proceratosaurus");
        this.setAnimator(new ProceratosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<ProceratosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.35f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<ProceratosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(2.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<ProceratosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.1f, 2.0f});
        miscProperties.setGuidebookOffset(new Vec2(-2.0f, 0.0f), new Vec2(-0.82f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.disableBabyGuidebook();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.setGuideBookDescription("Proceratosaurus is a genus of theropod dinosaur that lived during the Middle Jurassic in what is now England. The holotype and only known specimen consists of a mostly complete skull with an accompanying lower jaw and a hyoid bone.");
        miscProperties.setGuideBookSource("England");
        miscProperties.setGuideBookScientificName("Megalosaurus bradleyi");
        miscProperties.setAdvancementTitle("Clever Little Hunter");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<ProceratosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(Player.class, Animal.class, Monster.class, AbstractVillager.class, DryosaurusEntity.class, BasiliskEntity.class, GoatEntity.class, OstrichEntity.class, MicroceratusEntity.class, OthnielaEntity.class, MicroceratusEntity.class, CoelurusEntity.class);
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class, AchillobatorEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class);
        socialGroupProperties.addHerdTargets(ProceratosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(7);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
        socialGroupProperties.enableNesting();
    }

    @Override
    protected void applyItemProperties(JSItemProperties<ProceratosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.CHICKEN);
        itemProperties.setSpawnEggColors(7037503, 7625012);
        itemProperties.setSpawnEggColorsMale(5913895, 3089690);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<ProceratosaurusEntity> attributes, EntityBaseProperties<ProceratosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setSizeDimorphism(9.0);
        base.setMaxTurnRate(0.25);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setRenderScale(0.5);
        base.setLocator(new JSAnimalBaseLocator().setAdultOnly());
        base.setTurnSmoothRate((double)0.6f);
        attributes.setPersistent();
        attributes.setEntityFactory(ProceratosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(15.0);
        attributes.setDimensions((double)0.9f, (double)1.2f);
        attributes.setMovementSpeed((double)0.2f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.9f);
        attributes.setAttackDamage(9.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
    }
}

