/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TriceratopsEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.avian.LudodactylusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.BaryonyxEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.MetriacanthosaurusEntity;
import jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial.StyracosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class StyracosaurusAnimal
extends AbstractJSAnimal<StyracosaurusEntity> {
    public StyracosaurusAnimal() {
        super("styracosaurus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<StyracosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(1.0f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(new JSGene[0]);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<StyracosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(7.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(5.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<StyracosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.4f, 1.2f});
        miscProperties.setGuidebookOffset(new Vec2(-1.2f, 0.0f), new Vec2(-0.1f, 0.0f));
        miscProperties.setMachineScale(0.85f);
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.disableBabyGuidebook();
        miscProperties.setExtinct();
        miscProperties.setVersion(Versions.VERSION_2);
        miscProperties.setGuideBookDescription("Styracosaurus is an extinct genus of herbivorous ceratopsian dinosaur from the Late Cretaceous. It had four to six long parietal spikes extending from its neck frill, a smaller jugal horn on each of its cheeks.");
        miscProperties.setGuideBookSource("North America");
        miscProperties.setGuideBookScientificName("Styracosaurus ovatus");
        miscProperties.setAdvancementTitle("On a Warpath");
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<StyracosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHerdTargets(StyracosaurusEntity.class, TriceratopsEntity.class);
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class, BaryonyxEntity.class, MetriacanthosaurusEntity.class, LudodactylusEntity.class);
        socialGroupProperties.setMaxHerdSize(20);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<StyracosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(2897719, 10450972);
        itemProperties.setSpawnEggColorsMale(4870462, 8135452);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<StyracosaurusEntity> attributes, EntityBaseProperties<StyracosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90.0);
        base.setMaxTurnRate(7.0);
        base.setSizeDimorphism(9.0);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setTurnSmoothRate((double)0.7f);
        base.setRenderScale(1.0);
        base.setLocator(new JSAnimalBaseLocator());
        attributes.setPersistent();
        attributes.setEntityFactory(StyracosaurusEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(45.0);
        attributes.setDimensions((double)1.2f, (double)1.8f);
        attributes.setMovementSpeed((double)0.12f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(3.0);
        attributes.setAttackDamage(17.5);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
        attributes.setTrackingRange(64.0);
    }
}

