/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.entity.extant.avian;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAvianBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class ButterflyEntity
extends JSAvianBase {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ButterflyEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.f_19804_.m_135381_(VARIANT, (Object)this.f_19796_.m_188503_(ButterflyVariant.values().length));
        this.moveController = this.flyingMoveControl;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)1);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.f_19804_.m_135381_(VARIANT, (Object)this.f_19796_.m_188503_(ButterflyVariant.values().length));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("js.butterfly.variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128451_("js.butterfly.variant"));
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(6, 6));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 5));
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean shouldDieInstantly() {
        return true;
    }

    @Override
    public boolean disableFlyTransitions() {
        return true;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return this.getFlyingPathNavigation();
    }

    public int m_5792_() {
        return 40;
    }

    public ButterflyVariant getVariant() {
        return ButterflyVariant.fromId((Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public static boolean canSpawn(EntityType<? extends Entity> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(blockPos).m_60713_(Blocks.f_50016_) && serverLevelAccessor.m_45517_(LightLayer.SKY, blockPos) > 9;
    }

    public static enum ButterflyVariant {
        BIRDWING(0, "birdwing"),
        TROPONOPTERA(1, "trogonoptera");

        private final String name;
        private final int id;

        private ButterflyVariant(int id, String name) {
            this.name = name;
            this.id = id;
        }

        public static ButterflyVariant fromId(int t) {
            for (ButterflyVariant value : ButterflyVariant.values()) {
                if (value.id != t) continue;
                return value;
            }
            return BIRDWING;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

