/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v2.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatLeapTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSRangedAttack;
import jp.jurassicsaga.server.base.entity.obj.other.Spitter;
import jp.jurassicsaga.server.base.entity.obj.other.VenomSpit;
import jp.jurassicsaga.server.v2.animal.entity.obj.ProceratoFleeTask;
import jp.jurassicsaga.server.v2.sound.JSV2Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class ProceratosaurusEntity
extends JSAnimalBase
implements RangedAttackMob,
IJSRangedAttack,
Spitter {
    private boolean didSpit;

    public ProceratosaurusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new ProceratoFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(16, 9));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this).shouldCallout(true, 40).stalk());
        controller.registerTask((TravelerTaskBase)new JSCombatLeapTask(this, 0.5f));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 20;
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        JSGroundNavigation nav = new JSGroundNavigation(this, level);
        nav.setCanOpenDoors(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV2Sounds.PROCERATOSAURUS_ATTACK.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null) {
            return (SoundEvent)JSV2Sounds.PROCERATOSAURUS_THREAT.get();
        }
        return (SoundEvent)JSV2Sounds.PROCERATOSAURUS_LIVING.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSV2Sounds.PROCERATOSAURUS_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)JSV2Sounds.PROCERATOSAURUS_HURT.get();
    }

    @Override
    public void onSuccess() {
    }

    @Override
    public boolean shouldContinue() {
        return !this.didSpit && !this.isDead();
    }

    @Override
    public void reset() {
        this.didSpit = false;
    }

    @Override
    public boolean canUse() {
        return false;
    }

    @Override
    public void spit(LivingEntity livingEntity) {
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 90, 5, false, false));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20, 1, false, false));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 1, false, false));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 3, false, false));
        this.didSpit = true;
        if (livingEntity instanceof JSAnimalBase) {
            JSAnimalBase base = (JSAnimalBase)livingEntity;
            base.setFleeTarget((Entity)this);
        }
    }

    public void m_6504_(LivingEntity target, float v) {
        VenomSpit venomSpit = new VenomSpit(this.m_9236_(), this);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20186_() - venomSpit.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        venomSpit.m_6686_(d0, d1 + d3, d2, 1.5f, 1.0f);
        if (!this.m_20067_() && this.getAttackSound() != null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getAttackSound(), this.m_5720_(), this.m_6121_(), 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        this.m_9236_().m_7967_((Entity)venomSpit);
    }

    public boolean isDidSpit() {
        return this.didSpit;
    }

    public void setDidSpit(boolean didSpit) {
        this.didSpit = didSpit;
    }
}

